/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.collections.MultiMap;
import org.apache.wicket.util.io.StringBufferWriter;
import org.apache.wicket.util.string.AppendingStringBuffer;

class BufferedHttpServletResponse
implements HttpServletResponse {
    private StringBufferWriter sbw = new StringBufferWriter();
    private PrintWriter pw = new PrintWriter(this.sbw);
    private List<Cookie> cookies;
    private int status = -1;
    private MultiMap<String, Object> headers;
    private HttpServletResponse realResponse;
    private String redirect;
    private String contentType;
    private byte[] byteBuffer;
    private Locale locale;
    private String encoding;

    public BufferedHttpServletResponse(HttpServletResponse realResponse) {
        this.realResponse = realResponse;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.isOpen();
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>(2);
        }
        this.cookies.add(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        this.isOpen();
        if (this.headers == null) {
            return false;
        }
        return this.headers.containsKey(name);
    }

    @Override
    public String encodeURL(String url) {
        this.isOpen();
        return this.realResponse.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        this.isOpen();
        return this.realResponse.encodeRedirectURL(url);
    }

    @Override
    @Deprecated
    public String encodeUrl(String url) {
        this.isOpen();
        return this.realResponse.encodeURL(url);
    }

    @Override
    @Deprecated
    public String encodeRedirectUrl(String url) {
        this.isOpen();
        return this.realResponse.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.isOpen();
        this.realResponse.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.isOpen();
        this.realResponse.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.isOpen();
        this.redirect = location;
    }

    public String getRedirectUrl() {
        this.isOpen();
        return this.redirect;
    }

    private void testAndCreateHeaders() {
        this.isOpen();
        if (this.headers == null) {
            this.headers = new MultiMap();
        }
    }

    private void isOpen() {
        if (this.realResponse == null) {
            throw new WicketRuntimeException("the buffered servlet response already closed.");
        }
    }

    @Override
    public void setDateHeader(String name, long date) {
        this.testAndCreateHeaders();
        this.headers.replaceValues(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        this.testAndCreateHeaders();
        this.headers.addValue(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        this.testAndCreateHeaders();
        this.headers.replaceValues(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.testAndCreateHeaders();
        this.headers.addValue(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.testAndCreateHeaders();
        this.headers.replaceValues(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.testAndCreateHeaders();
        this.headers.addValue(name, value);
    }

    @Override
    public void setStatus(int statusCode) {
        this.status = statusCode;
    }

    @Override
    @Deprecated
    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
    }

    @Override
    public String getCharacterEncoding() {
        this.isOpen();
        return this.encoding;
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Cannot get output stream on BufferedResponse");
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        this.isOpen();
        return this.pw;
    }

    @Override
    public void setContentLength(int len) {
        this.isOpen();
    }

    @Override
    public void setContentType(String type) {
        this.isOpen();
        this.contentType = type;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setBufferSize(int size) {
        this.isOpen();
    }

    @Override
    public int getBufferSize() {
        this.isOpen();
        return Integer.MAX_VALUE;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.isOpen();
    }

    @Override
    public void resetBuffer() {
        this.isOpen();
        this.sbw.reset();
    }

    @Override
    public boolean isCommitted() {
        return this.pw == null;
    }

    @Override
    public void reset() {
        this.resetBuffer();
        this.headers = null;
        this.cookies = null;
    }

    @Override
    public void setLocale(Locale loc) {
        this.isOpen();
        this.locale = loc;
    }

    @Override
    public Locale getLocale() {
        this.isOpen();
        if (this.locale == null) {
            return this.realResponse.getLocale();
        }
        return this.locale;
    }

    public int getContentLength() {
        this.isOpen();
        return this.sbw.getStringBuffer().length();
    }

    public void close() {
        this.isOpen();
        this.pw.close();
        this.byteBuffer = BufferedHttpServletResponse.convertToCharset(this.sbw.getStringBuffer(), this.getCharacterEncoding());
        this.pw = null;
        this.sbw = null;
        this.realResponse = null;
    }

    private static byte[] convertToCharset(AppendingStringBuffer output, String encoding) {
        byte[] bytes;
        if (encoding == null) {
            throw new WicketRuntimeException("Internal error: encoding must not be null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)((double)output.length() * 1.2));
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, encoding);
            osw.write(output.getValue(), 0, output.length());
            osw.close();
            bytes = baos.toByteArray();
        }
        catch (Exception ex) {
            throw new WicketRuntimeException("Can't convert response to charset: " + encoding, ex);
        }
        return bytes;
    }

    public void writeTo(HttpServletResponse servletResponse) throws IOException {
        if (this.status != -1) {
            servletResponse.setStatus(this.status);
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (Object value : values) {
                    BufferedHttpServletResponse.addHeader(name, value, servletResponse);
                }
            }
        }
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                servletResponse.addCookie(cookie);
            }
        }
        if (this.locale != null) {
            servletResponse.setLocale(this.locale);
        }
        servletResponse.setContentLength(this.byteBuffer.length);
        servletResponse.setContentType(this.contentType);
        ServletOutputStream out = servletResponse.getOutputStream();
        out.write(this.byteBuffer);
        out.close();
    }

    private static void setHeader(String name, Object value, HttpServletResponse servletResponse) {
        if (value instanceof String) {
            servletResponse.setHeader(name, (String)value);
        } else if (value instanceof Long) {
            servletResponse.setDateHeader(name, (Long)value);
        } else if (value instanceof Integer) {
            servletResponse.setIntHeader(name, (Integer)value);
        }
    }

    private static void addHeader(String name, Object value, HttpServletResponse servletResponse) {
        if (value instanceof String) {
            servletResponse.addHeader(name, (String)value);
        } else if (value instanceof Long) {
            servletResponse.addDateHeader(name, (Long)value);
        } else if (value instanceof Integer) {
            servletResponse.addIntHeader(name, (Integer)value);
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getHeader(String name) {
        Object value = this.headers.getFirstValue(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List values = (List)this.headers.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(values.size());
        for (Object value : values) {
            ret.add(value.toString());
        }
        return ret;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this.headers.keySet());
    }
}

