/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.memory;

import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.pageStore.memory.IDataStoreEvictionStrategy;
import org.apache.wicket.pageStore.memory.PageTable;
import org.apache.wicket.pageStore.memory.PageTableCleaner;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class MemorySizeEvictionStrategy
implements IDataStoreEvictionStrategy {
    private final Bytes maxBytes;

    public MemorySizeEvictionStrategy(Bytes maxBytes) {
        Args.notNull(maxBytes, "maxBytes");
        this.maxBytes = maxBytes;
    }

    @Override
    public void evict(PageTable pageTable) {
        long storeCurrentSize = WicketObjects.sizeof(pageTable);
        if (storeCurrentSize > this.maxBytes.bytes()) {
            PageTableCleaner cleaner = new PageTableCleaner();
            cleaner.drop(pageTable, 1);
            this.evict(pageTable);
        }
    }
}

