/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractCachingPageStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.SecondLevelPageCache;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageStore
extends AbstractCachingPageStore<SerializedPage> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPageStore.class);

    public DefaultPageStore(ISerializer pageSerializer, IDataStore dataStore, int cacheSize) {
        super(pageSerializer, dataStore, new SerializedPagesCache(cacheSize));
    }

    @Override
    public void storePage(String sessionId, IManageablePage page) {
        SerializedPage serialized = this.createSerializedPage(sessionId, page);
        if (serialized != null) {
            int pageId = page.getPageId();
            this.pagesCache.storePage(sessionId, pageId, serialized);
            this.storePageData(sessionId, pageId, serialized.getData());
        }
    }

    @Override
    public IManageablePage convertToPage(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IManageablePage) {
            return (IManageablePage)object;
        }
        if (object instanceof SerializedPage) {
            SerializedPage page = (SerializedPage)object;
            byte[] data = page.getData();
            if (data == null) {
                data = this.getPageData(page.getSessionId(), page.getPageId());
            }
            if (data != null) {
                return this.deserializePage(data);
            }
            return null;
        }
        String type = object.getClass().getName();
        throw new IllegalArgumentException("Unknown object type " + type);
    }

    private SerializedPage restoreStrippedSerializedPage(SerializedPage serializedPage) {
        SerializedPage result = (SerializedPage)this.pagesCache.getPage(serializedPage.getSessionId(), serializedPage.getPageId());
        if (result != null) {
            return result;
        }
        byte[] data = this.getPageData(serializedPage.getSessionId(), serializedPage.getPageId());
        return new SerializedPage(serializedPage.getSessionId(), serializedPage.getPageId(), data);
    }

    @Override
    public Serializable prepareForSerialization(String sessionId, Serializable page) {
        if (this.dataStore.isReplicated()) {
            return null;
        }
        SerializedPage result = null;
        if (page instanceof IManageablePage) {
            IManageablePage _page = (IManageablePage)page;
            result = (SerializedPage)this.pagesCache.getPage(sessionId, _page.getPageId());
            if (result == null && (result = this.createSerializedPage(sessionId, _page)) != null) {
                this.pagesCache.storePage(sessionId, _page.getPageId(), result);
            }
        } else if (page instanceof SerializedPage) {
            SerializedPage _page = (SerializedPage)page;
            result = _page.getData() == null ? this.restoreStrippedSerializedPage(_page) : _page;
        }
        if (result != null) {
            return result;
        }
        return page;
    }

    protected boolean storeAfterSessionReplication() {
        return true;
    }

    @Override
    public Object restoreAfterSerialization(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        if (!this.storeAfterSessionReplication() || serializable instanceof IManageablePage) {
            return serializable;
        }
        if (serializable instanceof SerializedPage) {
            SerializedPage page = (SerializedPage)serializable;
            if (page.getData() != null) {
                this.storePageData(page.getSessionId(), page.getPageId(), page.getData());
                return new SerializedPage(page.getSessionId(), page.getPageId(), null);
            }
            return page;
        }
        String type = serializable.getClass().getName();
        throw new IllegalArgumentException("Unknown object type " + type);
    }

    protected SerializedPage createSerializedPage(String sessionId, IManageablePage page) {
        Args.notNull(sessionId, "sessionId");
        Args.notNull(page, "page");
        SerializedPage serializedPage = null;
        byte[] data = this.serializePage(page);
        if (data != null) {
            serializedPage = new SerializedPage(sessionId, page.getPageId(), data);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Page {} cannot be serialized. See previous logs for possible reasons.", (Object)page);
        }
        return serializedPage;
    }

    static class SerializedPagesCache
    implements SecondLevelPageCache<String, Integer, SerializedPage> {
        private final int maxSize;
        private final ConcurrentLinkedDeque<SoftReference<SerializedPage>> cache;

        public SerializedPagesCache(int maxSize) {
            this.maxSize = maxSize;
            this.cache = new ConcurrentLinkedDeque();
        }

        @Override
        public SerializedPage removePage(String sessionId, Integer pageId) {
            if (this.maxSize > 0) {
                Args.notNull(sessionId, "sessionId");
                Args.notNull(pageId, "pageId");
                SerializedPage sample = new SerializedPage(sessionId, pageId, null);
                Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                while (i.hasNext()) {
                    SoftReference<SerializedPage> ref = i.next();
                    SerializedPage entry = ref.get();
                    if (!sample.equals(entry)) continue;
                    i.remove();
                    return entry;
                }
            }
            return null;
        }

        @Override
        public void removePages(String sessionId) {
            if (this.maxSize > 0) {
                Args.notNull(sessionId, "sessionId");
                Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                while (i.hasNext()) {
                    SoftReference<SerializedPage> ref = i.next();
                    SerializedPage entry = ref.get();
                    if (entry == null || !entry.getSessionId().equals(sessionId)) continue;
                    i.remove();
                }
            }
        }

        @Override
        public SerializedPage getPage(String sessionId, Integer pageId) {
            SerializedPage result = null;
            if (this.maxSize > 0) {
                Args.notNull(sessionId, "sessionId");
                Args.notNull(pageId, "pageId");
                SerializedPage sample = new SerializedPage(sessionId, pageId, null);
                Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                while (i.hasNext()) {
                    SoftReference<SerializedPage> ref = i.next();
                    SerializedPage entry = ref.get();
                    if (!sample.equals(entry)) continue;
                    i.remove();
                    result = entry;
                    break;
                }
                if (result != null) {
                    this.internalStore(result);
                }
            }
            return result;
        }

        @Override
        public void storePage(String sessionId, Integer pageId, SerializedPage page) {
            if (this.maxSize > 0) {
                Args.notNull(sessionId, "sessionId");
                Args.notNull(pageId, "pageId");
                Args.notNull(page, "page");
                Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                while (i.hasNext()) {
                    SoftReference<SerializedPage> r = i.next();
                    SerializedPage entry = r.get();
                    if (entry == null || !entry.equals(page)) continue;
                    i.remove();
                    break;
                }
                this.internalStore(page);
            }
        }

        private void internalStore(SerializedPage page) {
            this.cache.push(new SoftReference<SerializedPage>(page));
            while (this.cache.size() > this.maxSize) {
                this.cache.pollLast();
            }
        }

        @Override
        public void destroy() {
            this.cache.clear();
        }
    }

    protected static class SerializedPage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int pageId;
        private final String sessionId;
        private final byte[] data;

        public SerializedPage(String sessionId, int pageId, byte[] data) {
            this.pageId = pageId;
            this.sessionId = sessionId;
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getPageId() {
            return this.pageId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SerializedPage)) {
                return false;
            }
            SerializedPage rhs = (SerializedPage)obj;
            return Objects.equal(this.getPageId(), rhs.getPageId()) && Objects.equal(this.getSessionId(), rhs.getSessionId());
        }

        public int hashCode() {
            return Objects.hashCode(this.getPageId(), this.getSessionId());
        }
    }
}

