/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageStore
implements IPageStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPageStore.class);
    protected final IDataStore dataStore;
    protected final ISerializer pageSerializer;

    protected AbstractPageStore(ISerializer pageSerializer, IDataStore dataStore) {
        Args.notNull(pageSerializer, "pageSerializer");
        Args.notNull(dataStore, "dataStore");
        this.pageSerializer = pageSerializer;
        this.dataStore = dataStore;
    }

    @Override
    public void destroy() {
        this.dataStore.destroy();
    }

    @Override
    public Serializable prepareForSerialization(String sessionId, Serializable page) {
        if (this.dataStore.isReplicated()) {
            return null;
        }
        return page;
    }

    @Override
    public Object restoreAfterSerialization(Serializable serializable) {
        return serializable;
    }

    protected byte[] getPageData(String sessionId, int pageId) {
        return this.dataStore.getData(sessionId, pageId);
    }

    protected void removePageData(String sessionId, int pageId) {
        this.dataStore.removeData(sessionId, pageId);
    }

    protected void removePageData(String sessionId) {
        this.dataStore.removeData(sessionId);
    }

    protected void storePageData(String sessionId, int pageId, byte[] data) {
        this.dataStore.storeData(sessionId, pageId, data);
    }

    protected byte[] serializePage(IManageablePage page) {
        Args.notNull(page, "page");
        byte[] data = this.pageSerializer.serialize(page);
        if (data == null && LOG.isWarnEnabled()) {
            LOG.warn("Page {} cannot be serialized. See previous logs for possible reasons.", (Object)page);
        }
        return data;
    }

    protected IManageablePage deserializePage(byte[] data) {
        Args.notNull(data, "data");
        return (IManageablePage)this.pageSerializer.deserialize(data);
    }
}

