/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPageStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.SecondLevelPageCache;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractCachingPageStore<P>
extends AbstractPageStore {
    protected final SecondLevelPageCache<String, Integer, P> pagesCache;

    protected AbstractCachingPageStore(ISerializer pageSerializer, IDataStore dataStore, SecondLevelPageCache<String, Integer, P> pagesCache) {
        super(pageSerializer, dataStore);
        this.pagesCache = Args.notNull(pagesCache, "pagesCache");
    }

    @Override
    public IManageablePage getPage(String sessionId, int pageId) {
        P fromCache = this.pagesCache.getPage(sessionId, pageId);
        if (fromCache != null) {
            return this.convertToPage(fromCache);
        }
        byte[] data = this.getPageData(sessionId, pageId);
        if (data != null) {
            return this.deserializePage(data);
        }
        return null;
    }

    @Override
    public void removePage(String sessionId, int pageId) {
        this.pagesCache.removePage(sessionId, pageId);
        this.removePageData(sessionId, pageId);
    }

    @Override
    public void storePage(String sessionId, IManageablePage page) {
        byte[] data = this.serializePage(page);
        if (data != null) {
            int pageId = page.getPageId();
            this.pagesCache.storePage(sessionId, pageId, page);
            this.storePageData(sessionId, pageId, data);
        }
    }

    @Override
    public void unbind(String sessionId) {
        this.removePageData(sessionId);
        this.pagesCache.removePages(sessionId);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.pagesCache.destroy();
    }
}

