/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.RequestAdapter;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractPageManager
implements IPageManager {
    private final IPageManagerContext context;

    public AbstractPageManager(IPageManagerContext context) {
        this.context = Args.notNull(context, "context");
    }

    protected abstract RequestAdapter newRequestAdapter(IPageManagerContext var1);

    @Override
    public IPageManagerContext getContext() {
        return this.context;
    }

    protected RequestAdapter getRequestAdapter() {
        RequestAdapter adapter = (RequestAdapter)this.getContext().getRequestData();
        if (adapter == null) {
            adapter = this.newRequestAdapter(this.getContext());
            this.getContext().setRequestData(adapter);
        }
        return adapter;
    }

    @Override
    public void commitRequest() {
        this.getRequestAdapter().commitRequest();
    }

    @Override
    public IManageablePage getPage(int id) {
        IManageablePage page = this.getRequestAdapter().getPage(id);
        if (page != null) {
            this.touchPage(page);
        }
        return page;
    }

    @Override
    public void newSessionCreated() {
        this.getRequestAdapter().newSessionCreated();
    }

    @Override
    public void touchPage(IManageablePage page) {
        this.getRequestAdapter().touch(page);
    }

    @Override
    public void untouchPage(IManageablePage page) {
        this.getRequestAdapter().untouch(page);
    }
}

