/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.collections.ArrayListStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlHandler
extends AbstractMarkupFilter {
    private static final Logger log = LoggerFactory.getLogger(HtmlHandler.class);
    private final ArrayListStack<ComponentTag> stack = new ArrayListStack();
    private static final Map<String, Boolean> doesNotRequireCloseTag = new HashMap<String, Boolean>();

    @Override
    public void postProcess(Markup markup) {
        while (this.stack.size() > 0) {
            ComponentTag top = this.stack.peek();
            if (!HtmlHandler.requiresCloseTag(top.getName())) {
                this.stack.pop();
                top.setHasNoCloseTag(true);
                continue;
            }
            throw new MarkupException(markup, "Tag does not have a close tag", null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag.isOpen()) {
            this.setContainsWicketIdFlag(tag);
            this.stack.push(tag);
            return tag;
        } else if (tag.isClose()) {
            boolean mismatch;
            if (this.stack.size() <= 0) throw new WicketParseException("Tag does not have a matching open tag:", tag);
            ComponentTag top = this.stack.pop();
            boolean bl = mismatch = !HtmlHandler.hasEqualTagName(top, tag);
            if (mismatch) {
                while (mismatch && !HtmlHandler.requiresCloseTag(top.getName())) {
                    top.setHasNoCloseTag(true);
                    top.setContainsWicketId(false);
                    if (this.stack.isEmpty()) break;
                    top = this.stack.pop();
                    mismatch = !HtmlHandler.hasEqualTagName(top, tag);
                }
                if (mismatch) {
                    throw new ParseException("Tag " + top.toUserDebugString() + " has a mismatched close tag at " + tag.toUserDebugString(), top.getPos());
                }
            }
            tag.setOpenTag(top);
            return tag;
        } else {
            if (!tag.isOpenClose()) return tag;
            tag.setOpenTag(tag);
        }
        return tag;
    }

    private void setContainsWicketIdFlag(ComponentTag tag) {
        boolean hasWicketId;
        String wicketIdAttr = this.getWicketNamespace() + ":" + "id";
        boolean bl = hasWicketId = tag.getAttributes().get(wicketIdAttr) != null;
        if (hasWicketId) {
            for (ComponentTag componentTag : this.stack) {
                componentTag.setContainsWicketId(hasWicketId);
            }
        }
    }

    public static boolean requiresCloseTag(String name) {
        return doesNotRequireCloseTag.get(name.toLowerCase()) == null;
    }

    public static boolean hasEqualTagName(ComponentTag tag1, ComponentTag tag2) {
        if (!tag1.getName().equalsIgnoreCase(tag2.getName())) {
            return false;
        }
        if (tag1.getNamespace() == null && tag2.getNamespace() == null) {
            return true;
        }
        if (tag1.getNamespace() != null && tag2.getNamespace() != null) {
            return tag1.getNamespace().equalsIgnoreCase(tag2.getNamespace());
        }
        return false;
    }

    static {
        doesNotRequireCloseTag.put("p", Boolean.TRUE);
        doesNotRequireCloseTag.put("br", Boolean.TRUE);
        doesNotRequireCloseTag.put("img", Boolean.TRUE);
        doesNotRequireCloseTag.put("input", Boolean.TRUE);
        doesNotRequireCloseTag.put("hr", Boolean.TRUE);
        doesNotRequireCloseTag.put("link", Boolean.TRUE);
        doesNotRequireCloseTag.put("meta", Boolean.TRUE);
        doesNotRequireCloseTag.put("area", Boolean.TRUE);
        doesNotRequireCloseTag.put("base", Boolean.TRUE);
        doesNotRequireCloseTag.put("col", Boolean.TRUE);
        doesNotRequireCloseTag.put("command", Boolean.TRUE);
        doesNotRequireCloseTag.put("embed", Boolean.TRUE);
        doesNotRequireCloseTag.put("keygen", Boolean.TRUE);
        doesNotRequireCloseTag.put("param", Boolean.TRUE);
        doesNotRequireCloseTag.put("source", Boolean.TRUE);
        doesNotRequireCloseTag.put("track", Boolean.TRUE);
        doesNotRequireCloseTag.put("wbr", Boolean.TRUE);
    }
}

