/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class AbstractMarkupSourcingStrategy
implements IMarkupSourcingStrategy {
    @Override
    public abstract IMarkupFragment getMarkup(MarkupContainer var1, Component var2);

    protected IMarkupFragment searchMarkupInTransparentResolvers(MarkupContainer container, IMarkupFragment containerMarkup, Component child) {
        IMarkupFragment childMarkupFound = null;
        Iterator<Component> siblingsIterator = container.iterator();
        final ArrayList<MarkupContainer> componentResolvers = new ArrayList<MarkupContainer>();
        container.visitChildren(IComponentResolver.class, new IVisitor<MarkupContainer, Void>(){

            @Override
            public void component(MarkupContainer child, IVisit<Void> visit) {
                componentResolvers.add(child);
            }
        });
        while (siblingsIterator.hasNext() && childMarkupFound == null) {
            IMarkupFragment siblingMarkup;
            Component sibling = siblingsIterator.next();
            if (sibling == child || !sibling.isVisible() || !(sibling instanceof MarkupContainer) || (siblingMarkup = containerMarkup.find(sibling.getId())) == null) continue;
            if (sibling instanceof IComponentResolver) {
                childMarkupFound = this.searchInNestedTransparentResolvers(containerMarkup, child, componentResolvers);
                continue;
            }
            childMarkupFound = this.searchMarkupInTransparentResolvers((MarkupContainer)sibling, siblingMarkup, child);
        }
        return childMarkupFound;
    }

    protected IMarkupFragment searchInNestedTransparentResolvers(IMarkupFragment containerMarkup, Component child, List<MarkupContainer> componentResolvers) {
        IMarkupFragment childMarkupFound = null;
        for (MarkupContainer componentResolver : componentResolvers) {
            IMarkupFragment childMarkup;
            IMarkupFragment resolverMarkup = containerMarkup.find(componentResolver.getId());
            IMarkupFragment iMarkupFragment = childMarkup = resolverMarkup != null ? resolverMarkup.find(child.getId()) : null;
            if (childMarkup != null) {
                IComponentResolver resolverContainer = (IComponentResolver)((Object)componentResolver);
                MarkupStream stream = new MarkupStream(childMarkup);
                ComponentTag tag = stream.getTag();
                Component resolvedComponent = componentResolver.get(tag.getId());
                if (resolvedComponent == null) {
                    resolvedComponent = resolverContainer.resolve(componentResolver, stream, tag);
                }
                if (child == resolvedComponent) {
                    childMarkupFound = childMarkup;
                }
            } else if (resolverMarkup != null) {
                ArrayList<MarkupContainer> otherResolvers = new ArrayList<MarkupContainer>(componentResolvers);
                otherResolvers.remove(componentResolver);
                childMarkupFound = this.searchInNestedTransparentResolvers(resolverMarkup, child, otherResolvers);
            }
            if (childMarkupFound == null) continue;
            break;
        }
        return childMarkupFound;
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        if (tag.isOpenClose()) {
            tag.setType(XmlTag.TagType.OPEN);
        }
    }

    @Override
    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        if (markupStream.getPreviousTag().isOpen()) {
            markupStream.skipRawMarkup();
            if (!markupStream.get().closes(openTag)) {
                throw new MarkupException(markupStream, "Close tag not found for tag: " + openTag.toString() + ". For " + Classes.simpleName(component.getClass()) + " Components only raw markup is allow in between the tags but not other Wicket Component." + ". Component: " + component.toString());
            }
        }
    }

    @Override
    public void renderHead(Component component, HtmlHeaderContainer container) {
    }
}

