/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class FileUpload
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final FileItem item;
    private transient List<InputStream> inputStreamsToClose;

    public FileUpload(FileItem item) {
        Args.notNull(item, "item");
        this.item = item;
    }

    public final void closeStreams() {
        if (this.inputStreamsToClose != null) {
            for (InputStream inputStream : this.inputStreamsToClose) {
                IOUtils.closeQuietly(inputStream);
            }
            this.inputStreamsToClose = null;
        }
    }

    public void delete() {
        this.item.delete();
    }

    public byte[] getBytes() {
        return this.item.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getDigest(String algorithm) {
        try {
            Args.notEmpty(algorithm, "algorithm");
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (this.item.isInMemory()) {
                digest.update(this.getBytes());
                return digest.digest();
            }
            InputStream in = null;
            try {
                int len;
                in = this.item.getInputStream();
                byte[] buf = new byte[Math.min((int)this.item.getSize(), 40960)];
                while (-1 != (len = in.read(buf))) {
                    digest.update(buf, 0, len);
                }
                byte[] byArray = digest.digest();
                return byArray;
            }
            catch (IOException ex) {
                throw new WicketRuntimeException("Error while reading input data for " + algorithm + " checksum", ex);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            String error = String.format("Your java runtime does not support digest algorithm [%s]. Please see java.security.MessageDigest.getInstance(\"%s\")", algorithm, algorithm);
            throw new WicketRuntimeException(error, ex);
        }
    }

    public byte[] getMD5() {
        return this.getDigest("MD5");
    }

    public String getClientFileName() {
        String name = this.item.getName();
        name = Strings.lastPathComponent(name, '/');
        name = Strings.lastPathComponent(name, '\\');
        return name;
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStreamsToClose == null) {
            this.inputStreamsToClose = new ArrayList<InputStream>();
        }
        InputStream is = this.item.getInputStream();
        this.inputStreamsToClose.add(is);
        return is;
    }

    public long getSize() {
        return this.item.getSize();
    }

    public void writeTo(File file) throws Exception {
        this.item.write(file);
    }

    public final File writeToTempFile() throws Exception {
        String sessionId = Session.exists() ? Session.get().getId() : "";
        String tempFileName = sessionId + "_" + RequestCycle.get().getStartTime();
        File temp = File.createTempFile(tempFileName, Files.cleanupFilename(this.item.getFieldName()));
        this.writeTo(temp);
        return temp;
    }
}

