/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.JavaScriptLibrarySettings;
import org.apache.wicket.util.string.Strings;

public class OnLoadHeaderItem
extends HeaderItem {
    private final CharSequence javaScript;

    public static OnLoadHeaderItem forScript(CharSequence javaScript) {
        return new OnLoadHeaderItem(javaScript);
    }

    public OnLoadHeaderItem() {
        this(null);
    }

    public OnLoadHeaderItem(CharSequence javaScript) {
        this.javaScript = javaScript;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        CharSequence js = this.getJavaScript();
        if (!Strings.isEmpty(js)) {
            JavaScriptUtils.writeJavaScript(response, "Wicket.Event.add(window, \"load\", function(event) { " + js + ";});");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-load-" + this.getJavaScript());
    }

    public String toString() {
        return "OnLoadHeaderItem('" + this.getJavaScript() + "')";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnLoadHeaderItem that = (OnLoadHeaderItem)o;
        return Objects.equals(this.javaScript, that.javaScript);
    }

    public int hashCode() {
        return Objects.hash(this.javaScript);
    }

    @Override
    public List<HeaderItem> getDependencies() {
        JavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketEventReference = ajaxSettings.getWicketEventReference();
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.add(JavaScriptHeaderItem.forReference(wicketEventReference));
        return dependencies;
    }
}

