/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.markup.head.AbstractJavaScriptReferenceHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUrlReferenceHeaderItem
extends AbstractJavaScriptReferenceHeaderItem {
    private final String url;

    public JavaScriptUrlReferenceHeaderItem(String url, String id, boolean defer, String charset, String condition) {
        super(condition, defer, charset);
        this.url = url;
        this.setId(id);
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get()), this.getId(), this.isDefer(), this.getCharset(), this.getCondition(), this.isAsync());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get());
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptUrlReferenceHeaderItem that = (JavaScriptUrlReferenceHeaderItem)o;
        return Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url);
    }
}

