/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class JavaScriptContentHeaderItem
extends JavaScriptHeaderItem {
    private final CharSequence javaScript;

    public JavaScriptContentHeaderItem(CharSequence javaScript, String id, String condition) {
        super(condition);
        this.javaScript = javaScript;
        this.setId(id);
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty(this.getCondition());
        if (hasCondition) {
            response.write("<!--[if ");
            response.write(this.getCondition());
            response.write("]>");
        }
        JavaScriptUtils.writeJavaScript(response, this.getJavaScript(), this.getId());
        if (hasCondition) {
            response.write("<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList(this.getJavaScript());
        }
        return Arrays.asList(this.getId(), this.getJavaScript());
    }

    public String toString() {
        return "JavaScriptHeaderItem(" + this.getJavaScript() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptContentHeaderItem that = (JavaScriptContentHeaderItem)o;
        return Objects.equals(this.javaScript, that.javaScript);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.javaScript);
    }
}

