/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssContentHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.CssUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CssHeaderItem
extends HeaderItem {
    private static final Logger logger = LoggerFactory.getLogger(CssHeaderItem.class);
    private final String condition;
    private String markupId;

    protected CssHeaderItem(String condition) {
        this.condition = condition;
    }

    public String getId() {
        return this.markupId;
    }

    public CssHeaderItem setId(String markupId) {
        this.markupId = markupId;
        return this;
    }

    public String getCondition() {
        return this.condition;
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference) {
        return CssHeaderItem.forReference(reference, null);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, String media) {
        return CssHeaderItem.forReference(reference, null, media);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String media) {
        return CssHeaderItem.forReference(reference, pageParameters, media, null);
    }

    public static CssReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String media, String condition) {
        return new CssReferenceHeaderItem(reference, pageParameters, media, condition);
    }

    public static CssContentHeaderItem forCSS(CharSequence css, String id) {
        return CssHeaderItem.forCSS(css, id, null);
    }

    public static CssContentHeaderItem forCSS(CharSequence css, String id, String condition) {
        return new CssContentHeaderItem(css, id, condition);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url) {
        return CssHeaderItem.forUrl(url, null);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url, String media) {
        return CssHeaderItem.forUrl(url, media, null);
    }

    public static CssUrlReferenceHeaderItem forUrl(String url, String media, String condition) {
        return new CssUrlReferenceHeaderItem(url, media, condition);
    }

    protected final void internalRenderCSSReference(Response response, String url, String media, String condition) {
        boolean hasCondition;
        Args.notEmpty(url, "url");
        boolean bl = hasCondition = !Strings.isEmpty(condition);
        if (hasCondition) {
            if (RequestCycle.get().find(IPartialPageRequestHandler.class) != null) {
                logger.warn("IE CSS engine doesn't support dynamically injected links in conditional comments. See the javadoc of IHeaderResponse for alternative solution.");
            }
            response.write("<!--[if ");
            response.write(condition);
            response.write("]>");
        }
        CssUtils.writeLinkUrl(response, url, media, this.getId());
        if (hasCondition) {
            response.write("<![endif]-->");
        }
        response.write("\n");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssHeaderItem that = (CssHeaderItem)o;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.markupId, that.markupId);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.markupId);
    }
}

