/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.ZeroPaddingIntegerConverter;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;

public class DateTimeField
extends FormComponentPanel<Date> {
    private static final long serialVersionUID = 1L;
    protected static final String DATE = "date";
    protected static final String HOURS = "hours";
    protected static final String MINUTES = "minutes";
    protected static final String AM_OR_PM_CHOICE = "amOrPmChoice";
    private static final String AM_OR_PM = "amOrPm";
    private static final IConverter<Integer> MINUTES_CONVERTER = new ZeroPaddingIntegerConverter(2);
    private DropDownChoice<AM_PM> amOrPmChoice;
    private AM_PM amOrPm = AM_PM.AM;
    private DateTextField dateField;
    private Date date;
    private TextField<Integer> hoursField;
    private Integer hours;
    private TextField<Integer> minutesField;
    private Integer minutes;

    public DateTimeField(String id) {
        this(id, (IModel<Date>)null);
    }

    public DateTimeField(String id, IModel<Date> model) {
        super(id, model);
        this.setType(Date.class);
        PropertyModel<Date> dateFieldModel = new PropertyModel<Date>(this, DATE);
        Component[] componentArray = new Component[1];
        this.dateField = this.newDateTextField(DATE, dateFieldModel);
        componentArray[0] = this.dateField;
        this.add(componentArray);
        this.dateField.add(this.newDatePicker());
        Component[] componentArray2 = new Component[1];
        this.hoursField = this.newHoursTextField(HOURS, new PropertyModel<Integer>(this, HOURS), Integer.class);
        componentArray2[0] = this.hoursField;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.minutesField = this.newMinutesTextField(MINUTES, new PropertyModel<Integer>(this, MINUTES), Integer.class);
        componentArray3[0] = this.minutesField;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.amOrPmChoice = new DropDownChoice<AM_PM>(AM_OR_PM_CHOICE, (IModel<AM_PM>)new PropertyModel(this, AM_OR_PM), Arrays.asList(AM_PM.values()));
        componentArray4[0] = this.amOrPmChoice;
        this.add(componentArray4);
        this.add(new WebMarkupContainer("hoursSeparator"){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isVisible() {
                return DateTimeField.this.minutesField.determineVisibility();
            }
        });
    }

    protected TextField<Integer> newHoursTextField(String id, IModel<Integer> model, Class<Integer> type) {
        TextField<Integer> hoursTextField = new TextField<Integer>(id, model, type);
        hoursTextField.add((IValidator<Integer>)(this.getMaximumHours() == 24 ? RangeValidator.range(0, 23) : RangeValidator.range(1, 12)));
        hoursTextField.setLabel(new Model<String>(HOURS));
        return hoursTextField;
    }

    protected TextField<Integer> newMinutesTextField(String id, IModel<Integer> model, Class<Integer> type) {
        TextField<Integer> minutesField = new TextField<Integer>(id, model, type){
            private static final long serialVersionUID = 1L;

            @Override
            public <C> IConverter<C> getConverter(Class<C> type) {
                if (Integer.class.isAssignableFrom(type)) {
                    return MINUTES_CONVERTER;
                }
                return super.getConverter(type);
            }
        };
        minutesField.add((IValidator<Integer>)new RangeValidator<Integer>(0, 59));
        minutesField.setLabel(new Model<String>(MINUTES));
        return minutesField;
    }

    protected final DateTextField getDateTextField() {
        return this.dateField;
    }

    public final AM_PM getAmOrPm() {
        return this.amOrPm;
    }

    public final Date getDate() {
        return this.date;
    }

    public final Integer getHours() {
        return this.hours;
    }

    public final Integer getMinutes() {
        return this.minutes;
    }

    protected void configure(Map<String, Object> widgetProperties) {
    }

    @Override
    public String getInput() {
        return this.dateField.getInput() + ", " + this.hoursField.getInput() + ":" + this.minutesField.getInput();
    }

    public final void setAmOrPm(AM_PM amOrPm) {
        this.amOrPm = amOrPm;
    }

    public final void setDate(Date date) {
        this.date = date;
    }

    public final void setHours(Integer hours) {
        this.hours = hours;
    }

    public final void setMinutes(Integer minutes) {
        this.minutes = minutes;
    }

    protected TimeZone getClientTimeZone() {
        ClientInfo info = Session.get().getClientInfo();
        if (info instanceof WebClientInfo) {
            return ((WebClientInfo)info).getProperties().getTimeZone();
        }
        return null;
    }

    @Override
    public void convertInput() {
        try {
            Date dateFieldInput = (Date)this.dateField.getConvertedInput();
            Integer hoursInput = (Integer)this.hoursField.getConvertedInput();
            Integer minutesInput = (Integer)this.minutesField.getConvertedInput();
            AM_PM amOrPmInput = (AM_PM)((Object)this.amOrPmChoice.getConvertedInput());
            if (dateFieldInput == null) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateFieldInput);
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int hours = hoursInput == null ? 0 : hoursInput % 24;
            int minutes = minutesInput == null ? 0 : minutesInput;
            MutableDateTime date = new MutableDateTime(year, month, day, hours, minutes, 0, 0, DateTimeZone.forTimeZone(this.getClientTimeZone()));
            if (this.use12HourFormat()) {
                int halfday = amOrPmInput == AM_PM.PM ? 1 : 0;
                date.set(DateTimeFieldType.halfdayOfDay(), halfday);
                date.set(DateTimeFieldType.hourOfHalfday(), hours % 12);
            }
            this.setConvertedInput(this.newDateInstance(date.getMillis()));
        }
        catch (RuntimeException e) {
            this.error((Serializable)((Object)e.getMessage()));
            this.invalid();
        }
    }

    protected Date newDateInstance() {
        return new Date();
    }

    protected Date newDateInstance(long time) {
        return new Date(time);
    }

    protected DateTextField newDateTextField(String id, PropertyModel<Date> dateFieldModel) {
        return DateTextField.forShortStyle(id, dateFieldModel, false);
    }

    @Override
    protected void onBeforeRender() {
        this.dateField.setRequired(this.isRequired());
        this.hoursField.setRequired(this.isRequired());
        this.minutesField.setRequired(this.isRequired());
        boolean use12HourFormat = this.use12HourFormat();
        this.amOrPmChoice.setVisible(use12HourFormat);
        Date modelObject = (Date)this.getDefaultModelObject();
        if (modelObject == null) {
            this.date = null;
            this.hours = null;
            this.minutes = null;
        } else {
            int hourOfHalfDay;
            MutableDateTime mDate = new MutableDateTime(modelObject);
            TimeZone zone = this.getClientTimeZone();
            if (zone != null) {
                mDate.setZone(DateTimeZone.forTimeZone(zone));
            }
            this.date = mDate.toDateTime().toLocalDate().toDate();
            this.hours = use12HourFormat ? Integer.valueOf((hourOfHalfDay = mDate.get(DateTimeFieldType.hourOfHalfday())) == 0 ? 12 : hourOfHalfDay) : Integer.valueOf(mDate.get(DateTimeFieldType.hourOfDay()));
            this.amOrPm = mDate.get(DateTimeFieldType.halfdayOfDay()) == 0 ? AM_PM.AM : AM_PM.PM;
            this.minutes = mDate.getMinuteOfHour();
        }
        super.onBeforeRender();
    }

    public static Date changeTimeZone(Date date, TimeZone zone) {
        Calendar first = Calendar.getInstance(zone);
        first.setTimeInMillis(date.getTime());
        Calendar output = Calendar.getInstance();
        output.set(1, first.get(1));
        output.set(2, first.get(2));
        output.set(5, first.get(5));
        output.set(11, first.get(11));
        output.set(12, first.get(12));
        output.set(13, first.get(13));
        output.set(14, first.get(14));
        return output.getTime();
    }

    protected boolean use12HourFormat() {
        String pattern = DateTimeFormat.patternForStyle("-S", this.getLocale());
        return pattern.indexOf(97) != -1 || pattern.indexOf(104) != -1 || pattern.indexOf(75) != -1;
    }

    private int getMaximumHours() {
        return this.getMaximumHours(this.use12HourFormat());
    }

    private int getMaximumHours(boolean use12HourFormat) {
        return use12HourFormat ? 12 : 24;
    }

    protected DatePicker newDatePicker() {
        return new DatePicker(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void configure(Map<String, Object> widgetProperties, IHeaderResponse response, Map<String, Object> initVariables) {
                super.configure(widgetProperties, response, initVariables);
                DateTimeField.this.configure(widgetProperties);
            }
        };
    }

    public static enum AM_PM {
        AM("AM"),
        PM("PM");

        private String value;

        private AM_PM(String name) {
            this.value = name;
        }

        public String toString() {
            return this.value;
        }
    }
}

