/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.extensions.wizard.Wizard;
import org.apache.wicket.extensions.wizard.WizardButton;
import org.apache.wicket.extensions.wizard.WizardButtonBar;
import org.apache.wicket.markup.ComponentTag;

public class AjaxWizardButtonBar
extends WizardButtonBar {
    private static final long serialVersionUID = 1L;

    public AjaxWizardButtonBar(String id, Wizard wizard) {
        super(id, wizard);
        wizard.setOutputMarkupId(true);
    }

    @Override
    public MarkupContainer add(Component ... childs) {
        for (Component component : childs) {
            if (!(component instanceof WizardButton)) continue;
            this.ajaxify((WizardButton)component);
        }
        return super.add(childs);
    }

    private void ajaxify(final WizardButton button) {
        button.add(new AjaxFormSubmitBehavior("click"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxWizardButtonBar.this.updateAjaxAttributes(attributes);
            }

            @Override
            public boolean getDefaultProcessing() {
                return button.getDefaultFormProcessing();
            }

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                target.add(AjaxWizardButtonBar.this.findParent(Wizard.class));
                button.onSubmit();
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target) {
                button.onAfterSubmit();
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                target.add(AjaxWizardButtonBar.this.findParent(Wizard.class));
                button.onError();
            }

            @Override
            protected void onComponentTag(ComponentTag tag) {
                tag.put("type", "button");
            }
        });
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }
}

