/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.util.encoding.CharSetMap;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharSetUtil {
    private static final Logger log = LoggerFactory.getLogger(CharSetUtil.class);
    private static CharSetMap charSetMap;

    private static synchronized void initialize(WebApplication application) {
        if (charSetMap == null) {
            ServletContext context = application.getServletContext();
            InputStream inputStream = context.getResourceAsStream("/WEB-INF/charset.properties");
            if (inputStream == null) {
                charSetMap = new CharSetMap();
                if (log.isDebugEnabled()) {
                    log.debug("File 'charset.properties' not found");
                }
            } else {
                try {
                    charSetMap = new CharSetMap(inputStream);
                }
                catch (IOException ex) {
                    throw new WicketRuntimeException("Error while reading CharSetMap", ex);
                }
            }
        }
    }

    public static String getEncoding(RequestCycle cycle) {
        if (charSetMap == null) {
            CharSetUtil.initialize((WebApplication)Application.get());
        }
        return charSetMap.getCharSet(Session.get().getLocale());
    }
}

