/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.rating;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class RatingPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference STAR0 = new PackageResourceReference(RatingPanel.class, "star0.gif");
    public static final ResourceReference STAR1 = new PackageResourceReference(RatingPanel.class, "star1.gif");
    private IModel<Integer> nrOfStars = new Model<Integer>(5);
    private final IModel<Integer> nrOfVotes;
    private final IModel<Boolean> hasVoted;
    private Component ratingLabel;
    private final boolean addDefaultCssStyle;

    public RatingPanel(String id) {
        this(id, null, 5, true);
    }

    public RatingPanel(String id, IModel<? extends Number> rating) {
        this(id, rating, new Model<Integer>(5), null, new Model<Boolean>(Boolean.FALSE), true);
    }

    public RatingPanel(String id, int nrOfStars) {
        this(id, null, nrOfStars, true);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, int nrOfStars, boolean addDefaultCssStyle) {
        this(id, rating, new Model<Integer>(nrOfStars), null, new Model<Boolean>(Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, int nrOfStars, IModel<Integer> nrOfVotes, boolean addDefaultCssStyle) {
        this(id, rating, new Model<Integer>(nrOfStars), nrOfVotes, new Model<Boolean>(Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel<? extends Number> rating, IModel<Integer> nrOfStars, IModel<Integer> nrOfVotes, IModel<Boolean> hasVoted, boolean addDefaultCssStyle) {
        super(id, rating);
        this.addDefaultCssStyle = addDefaultCssStyle;
        this.nrOfStars = this.wrap(nrOfStars);
        this.nrOfVotes = this.wrap(nrOfVotes);
        this.hasVoted = this.wrap(hasVoted);
        WebMarkupContainer rater = new WebMarkupContainer("rater");
        rater.add(this.newRatingStarBar("element", this.nrOfStars));
        this.ratingLabel = this.newRatingLabel("rating", this.wrap(rating), this.nrOfVotes);
        rater.add(this.ratingLabel);
        rater.setOutputMarkupId(true);
        this.add(rater);
        this.setRenderBodyOnly(true);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.addDefaultCssStyle) {
            response.render(CssHeaderItem.forReference(new CssResourceReference(RatingPanel.class, "RatingPanel.css")));
        }
    }

    protected Component newRatingStarBar(String id, IModel<Integer> nrOfStars) {
        return new RatingStarBar(id, nrOfStars);
    }

    protected Component newRatingLabel(String id, IModel<? extends Number> rating, IModel<Integer> nrOfVotes) {
        StringResourceModel model;
        if (nrOfVotes == null) {
            Object[] parameters = new Object[]{rating};
            model = new StringResourceModel("rating.simple", this).setParameters(parameters);
        } else {
            Object[] parameters = new Object[]{rating, nrOfVotes};
            model = new StringResourceModel("rating.complete", this).setParameters(parameters);
        }
        return new Label(id, model);
    }

    protected String getActiveStarUrl(int iteration) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(STAR1);
        return this.getRequestCycle().urlFor(handler).toString();
    }

    protected String getInactiveStarUrl(int iteration) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(STAR0);
        return this.getRequestCycle().urlFor(handler).toString();
    }

    public RatingPanel setRatingLabelVisible(boolean visible) {
        this.ratingLabel.setVisible(visible);
        return this;
    }

    protected abstract boolean onIsStarActive(int var1);

    protected abstract void onRated(int var1, AjaxRequestTarget var2);

    private final class RatingStarBar
    extends Loop {
        private static final long serialVersionUID = 1L;

        private RatingStarBar(String id, IModel<Integer> model) {
            super(id, model);
        }

        @Override
        protected void populateItem(LoopItem item) {
            AjaxFallbackLink<Void> link = new AjaxFallbackLink<Void>("link"){
                private static final long serialVersionUID = 1L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    LoopItem item = (LoopItem)this.getParent();
                    RatingPanel.this.onRated(item.getIndex() + 1, target);
                    if (target != null) {
                        target.add(RatingPanel.this.get("rater"));
                    }
                }

                @Override
                public boolean isEnabled() {
                    return (Boolean)RatingPanel.this.hasVoted.getObject() == false;
                }
            };
            int iteration = item.getIndex();
            link.add(new WebMarkupContainer("star").add(AttributeModifier.replace("src", (Serializable)((Object)(RatingPanel.this.onIsStarActive(iteration) ? RatingPanel.this.getActiveStarUrl(iteration) : RatingPanel.this.getInactiveStarUrl(iteration))))));
            item.add(link);
        }
    }
}

