/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.model.IModel;

public abstract class TreeModelProvider<T>
implements ITreeProvider<T> {
    private static final long serialVersionUID = 1L;
    private final TreeModel treeModel;
    private final boolean rootVisible;
    protected boolean completeUpdate;
    protected List<T> nodeUpdates;
    protected List<T> branchUpdates;

    public TreeModelProvider(TreeModel treeModel) {
        this(treeModel, true);
    }

    public TreeModelProvider(TreeModel treeModel, boolean rootVisible) {
        this.treeModel = treeModel;
        this.rootVisible = rootVisible;
        treeModel.addTreeModelListener(new Listener());
    }

    @Override
    public Iterator<T> getRoots() {
        if (this.rootVisible) {
            return new Iterator<T>(){
                boolean next = true;

                @Override
                public boolean hasNext() {
                    return this.next;
                }

                @Override
                public T next() {
                    this.next = false;
                    return TreeModelProvider.this.cast(TreeModelProvider.this.treeModel.getRoot());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.getChildren(this.cast(this.treeModel.getRoot()));
    }

    @Override
    public boolean hasChildren(T object) {
        return !this.treeModel.isLeaf(object);
    }

    @Override
    public Iterator<T> getChildren(final T object) {
        return new Iterator<T>(){
            private int size;
            private int index;
            {
                this.size = TreeModelProvider.this.treeModel.getChildCount(object);
                this.index = -1;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size - 1;
            }

            @Override
            public T next() {
                ++this.index;
                return TreeModelProvider.this.cast(TreeModelProvider.this.treeModel.getChild(object, this.index));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected T cast(Object object) {
        return (T)object;
    }

    @Override
    public abstract IModel<T> model(T var1);

    @Override
    public void detach() {
        this.completeUpdate = false;
        this.nodeUpdates = null;
        this.branchUpdates = null;
    }

    public void update(AbstractTree<T> tree, AjaxRequestTarget target) {
        if (this.completeUpdate) {
            target.add(tree);
        } else {
            if (this.nodeUpdates != null) {
                for (T object : this.nodeUpdates) {
                    tree.updateNode(object, target);
                }
            }
            if (this.branchUpdates != null) {
                for (T object : this.branchUpdates) {
                    tree.updateBranch(object, target);
                }
            }
        }
        this.detach();
    }

    protected void nodeUpdate(Object[] nodes) {
        if (this.nodeUpdates == null) {
            this.nodeUpdates = new ArrayList<T>();
        }
        for (Object node : nodes) {
            this.nodeUpdates.add(this.cast(node));
        }
    }

    protected void branchUpdate(Object branch) {
        if (this.branchUpdates == null) {
            this.branchUpdates = new ArrayList<T>();
        }
        this.branchUpdates.add(this.cast(branch));
    }

    private class Listener
    implements TreeModelListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Listener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (e.getChildIndices() == null) {
                TreeModelProvider.this.completeUpdate = true;
            } else {
                TreeModelProvider.this.nodeUpdate(e.getChildren());
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeModelProvider.this.branchUpdate(e.getTreePath().getLastPathComponent());
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeModelProvider.this.branchUpdate(e.getTreePath().getLastPathComponent());
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (e.getTreePath().getPathCount() == 1) {
                TreeModelProvider.this.completeUpdate = true;
            } else {
                TreeModelProvider.this.branchUpdate(e.getTreePath().getLastPathComponent());
            }
        }
    }
}

