/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.util;

import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class SortParam<T>
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final T property;
    private final boolean ascending;

    public SortParam(T property, boolean ascending) {
        Args.notNull(property, "property");
        this.property = property;
        this.ascending = ascending;
    }

    public T getProperty() {
        return this.property;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortParam)) {
            return false;
        }
        SortParam sortParam = (SortParam)o;
        return this.ascending == sortParam.ascending && this.property.equals(sortParam.property);
    }

    public int hashCode() {
        int result = this.property.hashCode();
        result = 31 * result + (this.ascending ? 1 : 0);
        return result;
    }

    public String toString() {
        return "[SortParam property=" + this.getProperty() + " ascending=" + this.ascending + "]";
    }
}

