/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree.table;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.request.Response;

public class NodeBorder
extends Behavior {
    private static final long serialVersionUID = 1L;
    private boolean[] branches;

    public NodeBorder(boolean[] branches) {
        this.branches = branches;
    }

    @Override
    public void beforeRender(Component component) {
        Response response = component.getResponse();
        for (int i = 0; i < this.branches.length; ++i) {
            if (i > 0) {
                response.write("<div class=\"tree-subtree\">");
            }
            if (this.branches[i]) {
                response.write("<div class=\"tree-branch tree-branch-mid\">");
                continue;
            }
            response.write("<div class=\"tree-branch tree-branch-last\">");
        }
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        tag.append("class", "tree-node", " ");
    }

    @Override
    public void afterRender(Component component) {
        Response response = component.getResponse();
        for (int i = 0; i < this.branches.length; ++i) {
            if (i > 0) {
                response.write("</div>");
            }
            response.write("</div>");
        }
    }
}

