/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree.nested;

import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.NestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.nested.BranchItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;

public class Subtree<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    private NestedTree<T> tree;

    public Subtree(String id, final NestedTree<T> tree, IModel<T> model) {
        super(id, model);
        if (tree == null) {
            throw new IllegalArgumentException("argument [tree] cannot be null");
        }
        this.tree = tree;
        RefreshingView branches = new RefreshingView<T>("branches"){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator<IModel<T>> getItemModels() {
                return new ModelIterator();
            }

            @Override
            protected Item<T> newItem(String id, int index, IModel<T> model) {
                return Subtree.this.newBranchItem(id, index, model);
            }

            @Override
            protected void populateItem(Item<T> item) {
                IModel model = item.getModel();
                Component node = tree.newNodeComponent("node", model);
                item.add(node);
                item.add(tree.newSubtree("subtree", model));
            }
        };
        branches.setItemReuseStrategy(new IItemReuseStrategy(){
            private static final long serialVersionUID = 1L;

            public <S> Iterator<Item<S>> getItems(IItemFactory<S> factory, Iterator<IModel<S>> newModels, Iterator<Item<S>> existingItems) {
                return tree.getItemReuseStrategy().getItems(factory, newModels, existingItems);
            }
        });
        this.add(branches);
    }

    public IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public T getModelObject() {
        return this.getModel().getObject();
    }

    protected BranchItem<T> newBranchItem(String id, int index, IModel<T> model) {
        return new BranchItem<T>(id, index, model);
    }

    @Override
    public boolean isVisible() {
        T t = this.getModel().getObject();
        if (t == null) {
            return true;
        }
        return this.tree.getState(t) == AbstractTree.State.EXPANDED;
    }

    private final class ModelIterator
    implements Iterator<IModel<T>> {
        private Iterator<? extends T> children;

        public ModelIterator() {
            Object t = Subtree.this.getModel().getObject();
            this.children = t == null ? Subtree.this.tree.getProvider().getRoots() : Subtree.this.tree.getProvider().getChildren(t);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.children.hasNext();
        }

        @Override
        public IModel<T> next() {
            return Subtree.this.tree.getProvider().model(this.children.next());
        }
    }
}

