/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree;

import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.HeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.tree.ISortableTreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.TableTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.content.Folder;
import org.apache.wicket.extensions.markup.html.repeater.tree.theme.WindowsTheme;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;

public class DefaultTableTree<T, S>
extends TableTree<T, S> {
    private static final long serialVersionUID = 1L;

    public DefaultTableTree(String id, List<? extends IColumn<T, S>> columns, ISortableTreeProvider<T, S> provider, int rowsPerPage) {
        this(id, (List<IColumn<T, S>>)columns, provider, rowsPerPage, (IModel<Set<T>>)null);
    }

    public DefaultTableTree(String id, List<? extends IColumn<T, S>> columns, ISortableTreeProvider<T, S> provider, int rowsPerPage, IModel<? extends Set<T>> state) {
        super(id, columns, provider, rowsPerPage, state);
        this.getTable().addTopToolbar(new NavigationToolbar(this.getTable()));
        this.getTable().addTopToolbar(new HeadersToolbar(this.getTable(), provider));
        this.getTable().addBottomToolbar(new NoRecordsToolbar(this.getTable()));
        this.add(new WindowsTheme());
    }

    @Override
    protected Component newContentComponent(String id, IModel<T> model) {
        return new Folder<T>(id, this, model);
    }

    @Override
    protected Item<T> newRowItem(String id, int index, IModel<T> node) {
        return new OddEvenItem<T>(id, index, node);
    }
}

