/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree;

import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.extensions.markup.html.repeater.util.ProviderSubset;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;

public abstract class AbstractTree<T>
extends Panel
implements IGenericComponent<Set<T>> {
    private static final long serialVersionUID = 1L;
    private ITreeProvider<T> provider;
    private IItemReuseStrategy itemReuseStrategy;

    protected AbstractTree(String id, ITreeProvider<T> provider) {
        this(id, provider, null);
    }

    protected AbstractTree(String id, ITreeProvider<T> provider, IModel<? extends Set<T>> state) {
        super(id, state);
        if (provider == null) {
            throw new IllegalArgumentException("argument [provider] cannot be null");
        }
        this.provider = provider;
    }

    public AbstractTree<T> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.itemReuseStrategy = strategy;
        return this;
    }

    public IItemReuseStrategy getItemReuseStrategy() {
        if (this.itemReuseStrategy == null) {
            return DefaultItemReuseStrategy.getInstance();
        }
        return this.itemReuseStrategy;
    }

    public ITreeProvider<T> getProvider() {
        return this.provider;
    }

    @Override
    protected IModel<?> initModel() {
        IModel<Object> model = super.initModel();
        if (model == null) {
            model = this.newModel();
        }
        return model;
    }

    protected IModel<Set<T>> newModel() {
        return new ProviderSubset<T>(this.provider).createModel();
    }

    @Override
    public IModel<Set<T>> getModel() {
        return this.getDefaultModel();
    }

    @Override
    public Set<T> getModelObject() {
        return this.getModel().getObject();
    }

    @Override
    public void setModel(IModel<Set<T>> model) {
        this.setDefaultModel((IModel)model);
    }

    @Override
    public void setModelObject(Set<T> state) {
        this.setDefaultModelObject(state);
    }

    public void expand(T t) {
        this.modelChanging();
        this.getModelObject().add(t);
        this.modelChanged();
        this.updateBranch(t, this.getRequestCycle().find(IPartialPageRequestHandler.class));
    }

    public void collapse(T t) {
        this.modelChanging();
        this.getModelObject().remove(t);
        this.modelChanged();
        this.updateBranch(t, this.getRequestCycle().find(IPartialPageRequestHandler.class));
    }

    public State getState(T t) {
        if (this.getModelObject().contains(t)) {
            return State.EXPANDED;
        }
        return State.COLLAPSED;
    }

    @Override
    protected void onDetach() {
        this.provider.detach();
        super.onDetach();
    }

    public Component newNodeComponent(String id, IModel<T> model) {
        return new Node<T>(id, this, model){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component createContent(String id, IModel<T> model) {
                return AbstractTree.this.newContentComponent(id, model);
            }
        };
    }

    protected abstract Component newContentComponent(String var1, IModel<T> var2);

    public abstract void updateBranch(T var1, IPartialPageRequestHandler var2);

    public abstract void updateNode(T var1, IPartialPageRequestHandler var2);

    public static enum State {
        COLLAPSED,
        EXPANDED;

    }
}

