/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.AbstractFilter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ChoiceFilter<T>
extends AbstractFilter {
    private static final long serialVersionUID = 1L;
    private final DropDownChoice<T> choice;

    public ChoiceFilter(String id, IModel<T> model, FilterForm<?> form, IModel<? extends List<? extends T>> choices, boolean autoSubmit) {
        this(id, model, form, choices, new ChoiceRenderer(), autoSubmit);
    }

    public ChoiceFilter(String id, IModel<T> model, FilterForm<?> form, List<? extends T> choices, boolean autoSubmit) {
        this(id, model, form, Model.ofList(choices), new ChoiceRenderer(), autoSubmit);
    }

    public ChoiceFilter(String id, IModel<T> model, FilterForm<?> form, List<? extends T> choices, IChoiceRenderer<? super T> renderer, boolean autoSubmit) {
        this(id, model, form, Model.ofList(choices), renderer, autoSubmit);
    }

    public ChoiceFilter(String id, IModel<T> model, FilterForm<?> form, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer, boolean autoSubmit) {
        super(id, form);
        this.choice = this.newDropDownChoice("filter", model, choices, renderer);
        if (autoSubmit) {
            this.choice.add(AttributeModifier.replace("onchange", (Serializable)((Object)"this.form.submit();")));
        }
        this.enableFocusTracking(this.choice);
        this.add(this.choice);
    }

    protected DropDownChoice<T> newDropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        DropDownChoice<T> dropDownChoice = new DropDownChoice<T>(id, model, choices, renderer);
        dropDownChoice.setNullValid(true);
        return dropDownChoice;
    }

    public final DropDownChoice<T> getChoice() {
        return this.choice;
    }
}

