/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class PropertyColumn<T, S>
extends AbstractColumn<T, S>
implements IExportableColumn<T, S> {
    private static final long serialVersionUID = 1L;
    private final String propertyExpression;

    public PropertyColumn(IModel<String> displayModel, S sortProperty, String propertyExpression) {
        super(displayModel, sortProperty);
        this.propertyExpression = propertyExpression;
    }

    public PropertyColumn(IModel<String> displayModel, String propertyExpression) {
        super(displayModel, null);
        this.propertyExpression = propertyExpression;
    }

    @Override
    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        item.add(new Label(componentId, this.getDataModel(rowModel)));
    }

    public String getPropertyExpression() {
        return this.propertyExpression;
    }

    @Override
    public IModel<?> getDataModel(IModel<T> rowModel) {
        PropertyModel propertyModel = new PropertyModel(rowModel, this.propertyExpression);
        return propertyModel;
    }
}

