/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.io.IClusterable;

public class NavigatorLabel
extends Label {
    private static final long serialVersionUID = 1L;

    public NavigatorLabel(String id, IPageableItems pageable) {
        super(id);
        this.setDefaultModel(new StringResourceModel("NavigatorLabel", this, new Model<LabelModelObject>(new LabelModelObject(pageable))));
    }

    private static class LabelModelObject
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final IPageableItems pageable;

        public LabelModelObject(IPageableItems table) {
            this.pageable = table;
        }

        public long getOf() {
            return this.pageable.getItemCount();
        }

        public long getFrom() {
            if (this.getOf() == 0L) {
                return 0L;
            }
            return this.pageable.getCurrentPage() * this.pageable.getItemsPerPage() + 1L;
        }

        public long getTo() {
            if (this.getOf() == 0L) {
                return 0L;
            }
            return Math.min(this.getOf(), this.getFrom() + this.pageable.getItemsPerPage() - 1L);
        }
    }
}

