/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NavigatorLabel;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.AbstractReadOnlyModel;

public class NavigationToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public NavigationToolbar(final DataTable<?, ?> table) {
        super(table);
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(span);
        span.add(AttributeModifier.replace("colspan", new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getObject() {
                return String.valueOf(table.getColumns().size()).intern();
            }
        }));
        span.add(this.newPagingNavigator("navigator", table));
        span.add(this.newNavigatorLabel("navigatorLabel", table));
    }

    protected PagingNavigator newPagingNavigator(String navigatorId, DataTable<?, ?> table) {
        return new PagingNavigator(navigatorId, table);
    }

    protected WebComponent newNavigatorLabel(String navigatorId, DataTable<?, ?> table) {
        return new NavigatorLabel(navigatorId, table);
    }

    @Override
    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(this.getTable().getPageCount() > 1L);
    }
}

