/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.sort;

import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByLink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.util.string.Strings;

public class OrderByBorder<S>
extends Border {
    private static final long serialVersionUID = 1L;
    public static final String SORT_ASCENDING_CSS_CLASS_KEY = CssUtils.key(OrderByLink.class, "ascending");
    public static final String SORT_DESCENDING_CSS_CLASS_KEY = CssUtils.key(OrderByLink.class, "descending");
    public static final String SORT_NONE_CSS_CLASS_KEY = CssUtils.key(OrderByLink.class, "none");
    private final ISortStateLocator<S> stateLocator;
    private final S property;

    public OrderByBorder(String id, S property, ISortStateLocator<S> stateLocator) {
        super(id);
        this.stateLocator = stateLocator;
        this.property = property;
        OrderByLink<S> link = this.newOrderByLink("orderByLink", property, stateLocator);
        this.addToBorder(link);
    }

    protected OrderByLink<S> newOrderByLink(String id, S property, ISortStateLocator<S> stateLocator) {
        return new OrderByLink<S>(id, property, stateLocator){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSortChanged() {
                OrderByBorder.this.onSortChanged();
            }
        };
    }

    protected void onSortChanged() {
    }

    @Override
    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        ISortState<S> sortState = this.stateLocator.getSortState();
        SortOrder dir = sortState.getPropertySortOrder(this.property);
        String cssClass = dir == SortOrder.ASCENDING ? this.getString(SORT_ASCENDING_CSS_CLASS_KEY) : (dir == SortOrder.DESCENDING ? this.getString(SORT_DESCENDING_CSS_CLASS_KEY) : this.getString(SORT_NONE_CSS_CLASS_KEY));
        if (!Strings.isEmpty(cssClass)) {
            tag.append("class", cssClass, " ");
        }
    }
}

