/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.grid;

import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.DataViewBase;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class AbstractDataGridView<T>
extends DataViewBase<T> {
    private static final long serialVersionUID = 1L;
    private static final String CELL_REPEATER_ID = "cells";
    private static final String CELL_ITEM_ID = "cell";
    private final List<? extends ICellPopulator<T>> populators;

    public AbstractDataGridView(String id, List<? extends ICellPopulator<T>> populators, IDataProvider<T> dataProvider) {
        super(id, dataProvider);
        this.populators = populators;
    }

    protected final List<? extends ICellPopulator<T>> internalGetPopulators() {
        return this.populators;
    }

    protected Item<ICellPopulator<T>> newCellItem(String id, int index, IModel<ICellPopulator<T>> model) {
        return new Item<ICellPopulator<T>>(id, index, model);
    }

    @Override
    protected final Item<T> newItem(String id, int index, IModel<T> model) {
        return this.newRowItem(id, index, model);
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new Item<T>(id, index, model);
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        if (this.populators != null) {
            for (ICellPopulator<T> populator : this.populators) {
                populator.detach();
            }
        }
    }

    @Override
    protected final void populateItem(Item<T> item) {
        RepeatingView cells = new RepeatingView(CELL_REPEATER_ID);
        item.add(cells);
        int populatorsNumber = this.populators.size();
        for (int i = 0; i < populatorsNumber; ++i) {
            ICellPopulator<T> populator = this.populators.get(i);
            Model<ICellPopulator<T>> populatorModel = new Model<ICellPopulator<T>>(populator);
            Item<ICellPopulator<T>> cellItem = this.newCellItem(cells.newChildId(), i, populatorModel);
            cells.add(cellItem);
            populator.populateItem(cellItem, CELL_ITEM_ID, item.getModel());
            if (cellItem.get(CELL_ITEM_ID) != null) continue;
            throw new WicketRuntimeException(populator.getClass().getName() + ".populateItem() failed to add a component with id [" + CELL_ITEM_ID + "] to the provided [cellItem] object. Make sure you call add() on cellItem and make sure you gave the added component passed in 'componentId' id. ( *cellItem*.add(new MyComponent(*componentId*, rowModel) )");
        }
    }
}

