/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import org.apache.wicket.IGenericComponent;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.select.Select;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class SelectOption<T>
extends WebMarkupContainer
implements IGenericComponent<T> {
    private static final long serialVersionUID = 1L;
    private int uuid = -1;

    public SelectOption(String id) {
        super(id);
    }

    public SelectOption(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    @Override
    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    @Override
    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    @Override
    public void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    public String getValue() {
        if (this.uuid < 0) {
            this.uuid = this.getPage().getAutoIndex();
        }
        return "option" + this.uuid;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "option");
        Select select = this.findParent(Select.class);
        if (select == null) {
            throw new WicketRuntimeException("SelectOption component [" + this.getPath() + "] cannot find its parent Select. All SelectOption components must be a child of or below in the hierarchy of a Select component.");
        }
        String uuid = this.getValue();
        tag.put("value", uuid);
        if (select.isSelected(this)) {
            tag.put("selected", "selected");
        }
        super.onComponentTag(tag);
    }
}

