/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette.component;

import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public abstract class AbstractOptions<T>
extends FormComponent<T> {
    private static final long serialVersionUID = 1L;
    private final Palette<T> palette;

    protected Palette<T> getPalette() {
        return this.palette;
    }

    public AbstractOptions(String id, Palette<T> palette) {
        super(id);
        this.palette = palette;
        this.setOutputMarkupId(true);
    }

    protected abstract Iterator<T> getOptionsIterator();

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        StringBuilder buffer = new StringBuilder(128);
        Iterator<T> options = this.getOptionsIterator();
        IChoiceRenderer<T> renderer = this.getPalette().getChoiceRenderer();
        boolean localizeDisplayValues = this.localizeDisplayValues();
        while (options.hasNext()) {
            T choice = options.next();
            CharSequence value = renderer.getIdValue(choice, 0);
            CharSequence id = this.getEscapeModelStrings() ? Strings.escapeMarkup(value) : value;
            Object displayValue = renderer.getDisplayValue(choice);
            Class<?> displayClass = displayValue == null ? null : displayValue.getClass();
            IConverter<?> converter = this.getConverter(displayClass);
            String displayString = converter.convertToString(displayValue, this.getLocale());
            if (localizeDisplayValues) {
                displayString = this.getLocalizer().getString(displayString, (Component)this, displayString);
            }
            value = this.getEscapeModelStrings() ? Strings.escapeMarkup(displayString) : displayString;
            buffer.append("\n<option value=\"").append(id).append("\"");
            Map<String, String> additionalAttributesMap = this.getAdditionalAttributes(choice);
            if (additionalAttributesMap != null) {
                for (Map.Entry<String, String> entry : additionalAttributesMap.entrySet()) {
                    buffer.append(' ').append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                }
            }
            buffer.append(">").append(value).append("</option>");
        }
        buffer.append("\n");
        this.replaceComponentTagBody(markupStream, openTag, buffer);
    }

    protected boolean localizeDisplayValues() {
        return true;
    }

    protected Map<String, String> getAdditionalAttributes(T choice) {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        super.onComponentTag(tag);
        IValueMap attrs = tag.getAttributes();
        attrs.put("multiple", "multiple");
        attrs.put("size", this.getPalette().getRows());
        if (!this.palette.isPaletteEnabled()) {
            attrs.put("disabled", "disabled");
        }
        this.avoidAjaxSerialization();
    }

    protected void avoidAjaxSerialization() {
        this.getResponse().write("<script type=\"text/javascript\">\n/*<![CDATA[*/\nif (typeof(Wicket) != \"undefined\" && typeof(Wicket.Form) != \"undefined\")    Wicket.Form.excludeFromAjaxSerialization." + this.getMarkupId() + "='true';" + "\n/*]]>*/\n</script>\n");
    }

    @Override
    public void updateModel() {
    }

    @Override
    protected String getModelValue() {
        return null;
    }
}

