/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.component.Choices;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.extensions.markup.html.form.palette.component.Selection;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;

public class Palette<T>
extends FormComponentPanel<Collection<T>> {
    private static final String SELECTED_HEADER_ID = "selectedHeader";
    private static final String AVAILABLE_HEADER_ID = "availableHeader";
    private static final long serialVersionUID = 1L;
    private final IModel<? extends Collection<? extends T>> choicesModel;
    private final IChoiceRenderer<? super T> choiceRenderer;
    private final int rows;
    private final boolean allowOrder;
    private final boolean allowMoveAll;
    private Recorder<T> recorderComponent;
    private Component choicesComponent;
    private Component selectionComponent;
    private static final ResourceReference JAVASCRIPT = new JQueryPluginResourceReference(Palette.class, "palette.js");

    public Palette(String id, IModel<? extends Collection<T>> choicesModel, IChoiceRenderer<? super T> choiceRenderer, int rows, boolean allowOrder) {
        this(id, null, choicesModel, choiceRenderer, rows, allowOrder);
    }

    public Palette(String id, IModel<? extends Collection<T>> model, IModel<? extends Collection<? extends T>> choicesModel, IChoiceRenderer<? super T> choiceRenderer, int rows, boolean allowOrder) {
        this(id, model, choicesModel, choiceRenderer, rows, allowOrder, false);
    }

    public Palette(String id, IModel<? extends Collection<T>> model, IModel<? extends Collection<? extends T>> choicesModel, IChoiceRenderer<? super T> choiceRenderer, int rows, boolean allowOrder, boolean allowMoveAll) {
        super(id, model);
        this.choicesModel = choicesModel;
        this.choiceRenderer = choiceRenderer;
        this.rows = rows;
        this.allowOrder = allowOrder;
        this.allowMoveAll = allowMoveAll;
    }

    @Override
    protected void onBeforeRender() {
        if (this.get("recorder") == null) {
            this.initFactories();
        }
        super.onBeforeRender();
    }

    private void initFactories() {
        this.recorderComponent = this.newRecorderComponent();
        this.add(this.recorderComponent);
        this.choicesComponent = this.newChoicesComponent();
        this.add(this.choicesComponent);
        this.selectionComponent = this.newSelectionComponent();
        this.add(this.selectionComponent);
        this.add(this.newAddComponent());
        this.add(this.newRemoveComponent());
        this.add(this.newUpComponent().setVisible(this.allowOrder));
        this.add(this.newDownComponent().setVisible(this.allowOrder));
        this.add(this.newAddAllComponent().setVisible(this.allowMoveAll));
        this.add(this.newRemoveAllComponent().setVisible(this.allowMoveAll));
        this.add(this.newAvailableHeader(AVAILABLE_HEADER_ID));
        this.add(this.newSelectedHeader(SELECTED_HEADER_ID));
    }

    public final boolean isPaletteEnabled() {
        return this.isEnabledInHierarchy();
    }

    public Iterator<T> getSelectedChoices() {
        return this.getRecorderComponent().getSelectedList().iterator();
    }

    public Iterator<T> getUnselectedChoices() {
        return this.getRecorderComponent().getUnselectedList().iterator();
    }

    protected Recorder<T> newRecorderComponent() {
        return new Recorder("recorder", this);
    }

    protected Component newAvailableHeader(String componentId) {
        return new Label(componentId, new ResourceModel("palette.available", "Available"));
    }

    protected Component newSelectedHeader(String componentId) {
        return new Label(componentId, new ResourceModel("palette.selected", "Selected"));
    }

    protected Component newDownComponent() {
        return new PaletteButton("moveDownButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put("onclick", Palette.this.getDownOnClickJS());
            }
        };
    }

    protected Component newUpComponent() {
        return new PaletteButton("moveUpButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put("onclick", Palette.this.getUpOnClickJS());
            }
        };
    }

    protected Component newRemoveComponent() {
        return new PaletteButton("removeButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put("onclick", Palette.this.getRemoveOnClickJS());
            }
        };
    }

    protected Component newAddComponent() {
        return new PaletteButton("addButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put("onclick", Palette.this.getAddOnClickJS());
            }
        };
    }

    protected Component newSelectionComponent() {
        return new Selection<T>("selection", this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return Palette.this.getAdditionalAttributesForSelection(choice);
            }

            @Override
            protected boolean localizeDisplayValues() {
                return Palette.this.localizeDisplayValues();
            }
        };
    }

    protected Component newAddAllComponent() {
        return new PaletteButton("addAllButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put("onclick", Palette.this.getAddAllOnClickJS());
            }
        };
    }

    protected Component newRemoveAllComponent() {
        return new PaletteButton("removeAllButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put("onclick", Palette.this.getRemoveAllOnClickJS());
            }
        };
    }

    protected Map<String, String> getAdditionalAttributesForSelection(Object choice) {
        return null;
    }

    protected Component newChoicesComponent() {
        return new Choices<T>("choices", this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return Palette.this.getAdditionalAttributesForChoices(choice);
            }

            @Override
            protected boolean localizeDisplayValues() {
                return Palette.this.localizeDisplayValues();
            }
        };
    }

    protected boolean localizeDisplayValues() {
        return true;
    }

    protected Map<String, String> getAdditionalAttributesForChoices(Object choice) {
        return null;
    }

    protected Component getChoicesComponent() {
        return this.choicesComponent;
    }

    protected Component getSelectionComponent() {
        return this.selectionComponent;
    }

    public final Recorder<T> getRecorderComponent() {
        return this.recorderComponent;
    }

    public Collection<? extends T> getChoices() {
        return this.choicesModel.getObject();
    }

    public Collection<T> getModelCollection() {
        return (Collection)this.getDefaultModelObject();
    }

    public IChoiceRenderer<? super T> getChoiceRenderer() {
        return this.choiceRenderer;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public void convertInput() {
        List<T> selectedList = this.getRecorderComponent().getSelectedList();
        if (selectedList.isEmpty()) {
            this.setConvertedInput(null);
        } else {
            this.setConvertedInput(selectedList);
        }
    }

    @Override
    public final void updateModel() {
        FormComponent.updateCollectionModel(this);
    }

    protected String buildJSCall(String funcName) {
        return funcName + "('" + this.getChoicesComponent().getMarkupId() + "','" + this.getSelectionComponent().getMarkupId() + "','" + this.getRecorderComponent().getMarkupId() + "');";
    }

    public String getChoicesOnFocusJS() {
        return this.buildJSCall("Wicket.Palette.choicesOnFocus");
    }

    public String getSelectionOnFocusJS() {
        return this.buildJSCall("Wicket.Palette.selectionOnFocus");
    }

    public String getAddOnClickJS() {
        return this.buildJSCall("Wicket.Palette.add");
    }

    public String getRemoveOnClickJS() {
        return this.buildJSCall("Wicket.Palette.remove");
    }

    public String getUpOnClickJS() {
        return this.buildJSCall("Wicket.Palette.moveUp");
    }

    public String getDownOnClickJS() {
        return this.buildJSCall("Wicket.Palette.moveDown");
    }

    public String getAddAllOnClickJS() {
        return this.buildJSCall("Wicket.Palette.addAll");
    }

    public String getRemoveAllOnClickJS() {
        return this.buildJSCall("Wicket.Palette.removeAll");
    }

    @Override
    protected void onDetach() {
        this.choicesModel.detach();
        super.onDetach();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        response.render(JavaScriptHeaderItem.forReference(JAVASCRIPT));
    }

    private class PaletteButton
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public PaletteButton(String id) {
            super(id);
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (!Palette.this.isPaletteEnabled()) {
                tag.getAttributes().put("disabled", "disabled");
            }
        }
    }
}

