/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class BreadCrumbParticipantDelegate
implements IBreadCrumbParticipant {
    private static final long serialVersionUID = 1L;
    private final Component component;

    public BreadCrumbParticipantDelegate(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component must be not null");
        }
        this.component = component;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void onActivate(IBreadCrumbParticipant previous) {
        if (previous != null) {
            MarkupContainer parent = previous.getComponent().getParent();
            if (parent != null) {
                final String thisId = this.component.getId();
                if (parent.get(thisId) != null) {
                    parent.replace(this.component);
                } else {
                    Component c = parent.visitChildren(new IVisitor<Component, Component>(){

                        @Override
                        public void component(Component component, IVisit<Component> visit) {
                            if (component.getId().equals(thisId)) {
                                visit.stop(component);
                            }
                        }
                    });
                    if (c == null) {
                        c = parent.visitParents(MarkupContainer.class, new IVisitor<MarkupContainer, Component>(){

                            @Override
                            public void component(MarkupContainer component, IVisit<Component> visit) {
                                if (component.getId().equals(thisId)) {
                                    visit.stop(component);
                                }
                            }
                        });
                    }
                    if (c != null) {
                        c.replaceWith(this.component);
                    }
                }
            }
        } else if (this.component.getParent() != null) {
            this.component.getParent().replace(this.component);
        }
    }
}

