/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb.panel;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.extensions.breadcrumb.panel.BreadCrumbParticipantDelegate;
import org.apache.wicket.extensions.breadcrumb.panel.IBreadCrumbPanelFactory;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class BreadCrumbPanel
extends Panel
implements IBreadCrumbParticipant {
    private static final long serialVersionUID = 1L;
    private IBreadCrumbModel breadCrumbModel;
    private final IBreadCrumbParticipant decorated = new BreadCrumbParticipantDelegate(this){
        private static final long serialVersionUID = 1L;

        @Override
        public IModel<String> getTitle() {
            return BreadCrumbPanel.this.getTitle();
        }
    };

    public BreadCrumbPanel(String id, IBreadCrumbModel breadCrumbModel) {
        super(id);
        this.breadCrumbModel = breadCrumbModel;
    }

    public BreadCrumbPanel(String id, IBreadCrumbModel breadCrumbModel, IModel<?> model) {
        super(id, model);
        this.breadCrumbModel = breadCrumbModel;
    }

    public void activate(IBreadCrumbPanelFactory breadCrumbPanelFactory) {
        this.activate(breadCrumbPanelFactory.create(this.getId(), this.breadCrumbModel));
    }

    public void activate(IBreadCrumbParticipant participant) {
        IBreadCrumbParticipant active = this.breadCrumbModel.getActive();
        if (active == null) {
            throw new IllegalStateException("The model has no active bread crumb. Before using " + this + ", you have to have at least one bread crumb in the model");
        }
        this.addStateChange();
        this.breadCrumbModel.setActive(participant);
    }

    public final IBreadCrumbModel getBreadCrumbModel() {
        return this.breadCrumbModel;
    }

    @Override
    public Component getComponent() {
        return this.decorated.getComponent();
    }

    @Override
    public void onActivate(IBreadCrumbParticipant previous) {
        this.decorated.onActivate(previous);
    }

    public final void setBreadCrumbModel(IBreadCrumbModel breadCrumbModel) {
        this.breadCrumbModel = breadCrumbModel;
    }
}

