/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequestImpl;
import org.apache.wicket.protocol.http.servlet.UploadInfo;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.time.Duration;

class UploadStatusResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private static final String UPLOAD_PARAMETER = "upload";
    public static final String RESOURCE_STATUS = "UploadStatusResource.status";

    UploadStatusResource() {
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("text/html; charset=" + encoding);
        response.setCacheDuration(Duration.NONE);
        final String status = this.getStatus(attributes);
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            @Override
            public void writeData(IResource.Attributes attributes) {
                attributes.getResponse().write("<html><body>|");
                attributes.getResponse().write(status);
                attributes.getResponse().write("|</body></html>");
            }
        });
        return response;
    }

    private String getStatus(IResource.Attributes attributes) {
        String upload = attributes.getParameters().get(UPLOAD_PARAMETER).toString();
        HttpServletRequest req = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        UploadInfo info = MultipartServletWebRequestImpl.getUploadInfo(req, upload);
        String status = info == null || info.getTotalBytes() < 1L ? "100|" : info.getPercentageComplete() + "|" + new StringResourceModel(RESOURCE_STATUS, null, Model.of(info)).getString();
        return status;
    }

    public static PageParameters newParameter(String upload) {
        return new PageParameters().add(UPLOAD_PARAMETER, upload);
    }
}

