/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import java.util.Formatter;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadStatusResource;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class UploadProgressBar
extends Panel {
    public static final String RESOURCE_STARTING = "UploadProgressBar.starting";
    private static final ResourceReference JS = new JavaScriptResourceReference(UploadProgressBar.class, "progressbar.js");
    private static final ResourceReference CSS = new CssResourceReference(UploadProgressBar.class, "UploadProgressBar.css");
    private static final String RESOURCE_NAME = UploadProgressBar.class.getName();
    private static final long serialVersionUID = 1L;
    private final Form<?> form;
    private MarkupContainer statusDiv;
    private MarkupContainer barDiv;
    private final FileUploadField uploadField;

    public UploadProgressBar(String id, Form<?> form) {
        this(id, form, null);
    }

    public UploadProgressBar(String id, Form<?> form, FileUploadField uploadField) {
        super(id);
        this.uploadField = uploadField;
        if (uploadField != null) {
            uploadField.setOutputMarkupId(true);
        }
        this.form = Args.notNull(form, "form");
        form.setOutputMarkupId(true);
        this.setRenderBodyOnly(true);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.getCallbackForm().setOutputMarkupId(true);
        this.barDiv = this.newBarComponent("bar");
        this.add(this.barDiv);
        this.statusDiv = this.newStatusComponent("status");
        this.add(this.statusDiv);
    }

    protected MarkupContainer newStatusComponent(String id) {
        WebMarkupContainer status = new WebMarkupContainer(id);
        status.setOutputMarkupId(true);
        return status;
    }

    protected MarkupContainer newBarComponent(String id) {
        WebMarkupContainer bar = new WebMarkupContainer(id);
        bar.setOutputMarkupId(true);
        return bar;
    }

    protected ResourceReference getCss() {
        return CSS;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        CoreLibrariesContributor.contributeAjax(this.getApplication(), response);
        response.render(JavaScriptHeaderItem.forReference(JS));
        ResourceReference css = this.getCss();
        if (css != null) {
            response.render(CssHeaderItem.forReference(css));
        }
        SharedResourceReference ref = new SharedResourceReference(RESOURCE_NAME);
        String uploadFieldId = this.uploadField == null ? "" : this.uploadField.getMarkupId();
        String status = new StringResourceModel(RESOURCE_STARTING, this, null).getString();
        CharSequence url = this.urlFor(ref, UploadStatusResource.newParameter(this.getPage().getId()));
        StringBuilder builder = new StringBuilder(128);
        Formatter formatter = new Formatter(builder);
        formatter.format("new Wicket.WUPB('%s', '%s', '%s', '%s', '%s', '%s');", this.getCallbackForm().getMarkupId(), this.statusDiv.getMarkupId(), this.barDiv.getMarkupId(), url, uploadFieldId, status);
        response.render(OnDomReadyHeaderItem.forScript(builder.toString()));
    }

    private Form<?> getCallbackForm() {
        Boolean insideModal = this.form.visitParents(ModalWindow.class, new IVisitor<ModalWindow, Boolean>(){

            @Override
            public void component(ModalWindow object, IVisit<Boolean> visit) {
                visit.stop(true);
            }
        });
        if (insideModal != null && insideModal.booleanValue()) {
            return this.form;
        }
        return this.form.getRootForm();
    }

    public static final class ComponentInitializer
    implements IInitializer {
        @Override
        public void init(Application application) {
            application.getSharedResources().add(RESOURCE_NAME, new UploadStatusResource());
        }

        public String toString() {
            return "UploadProgressBar initializer";
        }

        @Override
        public void destroy(Application application) {
        }
    }
}

