/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import java.util.Iterator;
import org.apache.wicket.Application;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public abstract class AutoCompleteBehavior<T>
extends AbstractAutoCompleteBehavior {
    private static final long serialVersionUID = 1L;
    private final IAutoCompleteRenderer<T> renderer;

    public AutoCompleteBehavior(IAutoCompleteRenderer<T> renderer) {
        this(renderer, false);
    }

    public AutoCompleteBehavior(IAutoCompleteRenderer<T> renderer, boolean preselect) {
        this(renderer, new AutoCompleteSettings().setPreselect(preselect));
    }

    public AutoCompleteBehavior(IAutoCompleteRenderer<T> renderer, AutoCompleteSettings settings) {
        super(settings);
        this.renderer = Args.notNull(renderer, "renderer");
    }

    @Override
    protected final void onRequest(final String val, RequestCycle requestCycle) {
        IRequestHandler target = new IRequestHandler(){

            @Override
            public void respond(IRequestCycle requestCycle) {
                WebResponse r = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                r.setContentType("text/xml; charset=" + encoding);
                r.disableCaching();
                Iterator comps = AutoCompleteBehavior.this.getChoices(val);
                int count = 0;
                AutoCompleteBehavior.this.renderer.renderHeader(r);
                while (comps.hasNext()) {
                    Object comp = comps.next();
                    AutoCompleteBehavior.this.renderer.render(comp, r, val);
                    ++count;
                }
                AutoCompleteBehavior.this.renderer.renderFooter(r, count);
            }

            @Override
            public void detach(IRequestCycle requestCycle) {
            }
        };
        requestCycle.scheduleRequestHandlerAfterCurrent(target);
    }

    protected abstract Iterator<T> getChoices(String var1);
}

