/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractAutoCompleteRenderer<T>
implements IAutoCompleteRenderer<T> {
    private static final long serialVersionUID = 1L;

    @Override
    public void render(T object, Response response, String criteria) {
        String textValue = this.getTextValue(object);
        if (textValue == null) {
            throw new IllegalStateException("A call to textValue(Object) returned an illegal value: null for object: " + object.toString());
        }
        textValue = Strings.escapeMarkup(textValue).toString();
        response.write("<li textvalue=\"" + textValue + "\"");
        CharSequence handler = this.getOnSelectJavaScriptExpression(object);
        if (handler != null) {
            response.write(" onselect=\"" + handler + '\"');
        }
        response.write(">");
        this.renderChoice(object, response, criteria);
        response.write("</li>");
    }

    @Override
    public void renderHeader(Response response) {
        response.write("<ul>");
    }

    @Override
    public void renderFooter(Response response, int count) {
        response.write("</ul>");
    }

    protected abstract void renderChoice(T var1, Response var2, String var3);

    protected abstract String getTextValue(T var1);

    protected CharSequence getOnSelectJavaScriptExpression(T item) {
        return null;
    }
}

