/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.util.List;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxLazyLoadPanel;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxLazyLoadPanelTester {
    private static final Logger logger = LoggerFactory.getLogger(AjaxLazyLoadPanelTester.class);

    public static void executeAjaxLazyLoadPanel(final BaseWicketTester wt, MarkupContainer container) {
        container.visitChildren(AjaxLazyLoadPanel.class, new IVisitor<AjaxLazyLoadPanel, Void>(){

            @Override
            public void component(AjaxLazyLoadPanel component, IVisit<Void> visit) {
                List<AbstractAjaxBehavior> behaviors = component.getBehaviors(AbstractAjaxBehavior.class);
                if (behaviors.size() == 0) {
                    logger.warn("AjaxLazyLoadPanel child found, but no attached AbstractAjaxBehaviors found. A curious situation...");
                }
                for (Behavior behavior : behaviors) {
                    if (behavior instanceof AjaxSelfUpdatingTimerBehavior) continue;
                    logger.debug("Triggering lazy panel: " + component.getClassRelativePath());
                    AbstractAjaxBehavior abstractAjaxBehaviour = (AbstractAjaxBehavior)behavior;
                    wt.executeBehavior(abstractAjaxBehaviour);
                }
            }
        });
    }
}

