/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;

public class AjaxIndicatorAppender
extends Behavior {
    private Component component;
    private static final long serialVersionUID = 1L;

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        IPartialPageRequestHandler target = component.getRequestCycle().find(IPartialPageRequestHandler.class);
        if (target != null) {
            String javascript = "var e = Wicket.$('" + this.getMarkupId() + "'); if (e != null && typeof(e.parentNode) != 'undefined') e.parentNode.removeChild(e);";
            target.prependJavaScript(javascript);
        }
    }

    @Override
    public void afterRender(Component component) {
        super.afterRender(component);
        Response r = component.getResponse();
        r.write("<span style=\"display:none;\" class=\"");
        r.write(this.getSpanClass());
        r.write("\" ");
        r.write("id=\"");
        r.write(this.getMarkupId());
        r.write("\">");
        r.write("<img src=\"");
        r.write(this.getIndicatorUrl());
        r.write("\" alt=\"\"/></span>");
    }

    protected CharSequence getIndicatorUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        return RequestCycle.get().urlFor(handler);
    }

    protected String getSpanClass() {
        return "wicket-ajax-indicator";
    }

    public String getMarkupId() {
        return this.component.getMarkupId() + "--ajax-indicator";
    }

    @Override
    public final void bind(Component component) {
        this.component = component;
    }
}

