/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidator;

public class AjaxEditableLabel<T>
extends Panel
implements IGenericComponent<T> {
    private static final long serialVersionUID = 1L;
    private FormComponent<T> editor;
    private Component label;

    protected void updateLabelAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected void updateEditorAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    public AjaxEditableLabel(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    public AjaxEditableLabel(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public final AjaxEditableLabel<T> add(IValidator<T> validator) {
        this.getEditor().add(validator);
        return this;
    }

    @Override
    public <C> IConverter<C> getConverter(Class<C> type) {
        return null;
    }

    public final AjaxEditableLabel<T> setLabel(IModel<String> labelModel) {
        this.getEditor().setLabel((IModel)labelModel);
        return this;
    }

    @Override
    public final AjaxEditableLabel<T> setDefaultModel(IModel<?> model) {
        super.setDefaultModel((IModel)model);
        this.getLabel().setDefaultModel(model);
        this.getEditor().setDefaultModel((IModel)model);
        return this;
    }

    @Override
    public IModel<T> getModel() {
        return this.getDefaultModel();
    }

    @Override
    public T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    @Override
    public void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    @Override
    public void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    public final AjaxEditableLabel<T> setRequired(boolean required) {
        this.getEditor().setRequired(required);
        return this;
    }

    public final AjaxEditableLabel<T> setType(Class<?> type) {
        this.getEditor().setType(type);
        return this;
    }

    protected FormComponent<T> newEditor(MarkupContainer parent, String componentId, IModel<T> model) {
        TextField editor = new TextField<T>(componentId, model){
            private static final long serialVersionUID = 1L;

            @Override
            public <C> IConverter<C> getConverter(Class<C> type) {
                IConverter<C> c = AjaxEditableLabel.this.getConverter(type);
                return c != null ? c : super.getConverter(type);
            }

            @Override
            protected void onModelChanged() {
                super.onModelChanged();
                AjaxEditableLabel.this.onModelChanged();
            }

            @Override
            protected void onModelChanging() {
                super.onModelChanging();
                AjaxEditableLabel.this.onModelChanging();
            }
        };
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add(new EditorAjaxBehavior(){

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setEventNames("blur", "keyup", "keydown");
                attributes.setPreventDefault(false);
                String precondition = "var kc=Wicket.Event.keyCode(attrs.event),evtType=attrs.event.type,ret=false;if (evtType==='blur' || (evtType==='keyup' && kc===27) || (evtType==='keydown' && kc===13)) {attrs.event.preventDefault(); ret = true;}return ret;";
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition(precondition);
                String dynamicExtraParameters = "var result,evtType=attrs.event.type;if (evtType === 'keyup') { result = { 'save': false }; }else { result = { 'save': true }; }return result;";
                attributes.getDynamicExtraParameters().add(dynamicExtraParameters);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        });
        return editor;
    }

    protected Component newLabel(MarkupContainer parent, String componentId, IModel<T> model) {
        Label label = new Label(componentId, model){
            private static final long serialVersionUID = 1L;

            @Override
            public <C> IConverter<C> getConverter(Class<C> type) {
                IConverter<C> c = AjaxEditableLabel.this.getConverter(type);
                return c != null ? c : super.getConverter(type);
            }

            @Override
            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                Object modelObject = this.getDefaultModelObject();
                if (modelObject == null || "".equals(modelObject)) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add(new LabelAjaxBehavior(this.getLabelAjaxEvent()));
        return label;
    }

    protected String getLabelAjaxEvent() {
        return "click";
    }

    protected final FormComponent<T> getEditor() {
        if (this.editor == null) {
            this.initLabelAndEditor(new WrapperModel());
        }
        return this.editor;
    }

    protected final Component getLabel() {
        if (this.label == null) {
            this.initLabelAndEditor(new WrapperModel());
        }
        return this.label;
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.editor == null) {
            this.initLabelAndEditor(new WrapperModel());
        }
    }

    protected void onCancel(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        this.editor.clearInput();
        target.add(this);
    }

    public void onEdit(AjaxRequestTarget target) {
        this.label.setVisible(false);
        this.editor.setVisible(true);
        target.add(this);
        String selectScript = String.format("(function(){var el = Wicket.$('%s'); if (el.select) el.select();})()", this.editor.getMarkupId());
        target.appendJavaScript(selectScript);
        target.focusComponent(this.editor);
    }

    protected void onError(AjaxRequestTarget target) {
        if (this.editor.hasErrorMessage()) {
            FeedbackMessage errorMessage = this.editor.getFeedbackMessages().first(400);
            target.appendJavaScript("window.status='" + JavaScriptUtils.escapeQuotes(((Object)errorMessage).toString()) + "';");
        }
        String selectAndFocusScript = String.format("(function(){var el=Wicket.$('%s'); if (el.select) el.select(); el.focus();})()", this.editor.getMarkupId());
        target.appendJavaScript(selectAndFocusScript);
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        target.add(this);
        target.appendJavaScript("window.status='';");
    }

    private void initLabelAndEditor(IModel<T> model) {
        this.editor = this.newEditor(this, "editor", model);
        this.label = this.newLabel(this, "label", model);
        this.add(this.label);
        this.add(this.editor);
    }

    private IModel<T> getParentModel() {
        IModel<T> m = this.getModel();
        if (m == null) {
            MarkupContainer parent = this.getParent();
            String msg = "No model found for this component, either pass one explicitly or make sure an inheritable model is available.";
            if (parent == null) {
                msg = msg + " This component is not added to a parent yet, so if this component is supposed to use the model of the parent (e.g. when it uses a compound property model), add it first before further configuring the component calling methods like e.g. setType and addValidator.";
            }
            throw new IllegalStateException(msg);
        }
        return m;
    }

    protected String defaultNullLabel() {
        return "...";
    }

    @Override
    protected void onModelChanged() {
        super.onModelChanged();
    }

    @Override
    protected void onModelChanging() {
        super.onModelChanging();
    }

    private class WrapperModel
    implements IModel<T>,
    IObjectClassAwareModel<T> {
        private WrapperModel() {
        }

        @Override
        public T getObject() {
            return AjaxEditableLabel.this.getParentModel().getObject();
        }

        @Override
        public void setObject(T object) {
            AjaxEditableLabel.this.getParentModel().setObject(object);
        }

        @Override
        public void detach() {
            AjaxEditableLabel.this.getParentModel().detach();
        }

        @Override
        public Class<T> getObjectClass() {
            if (AjaxEditableLabel.this.getParentModel() instanceof IObjectClassAwareModel) {
                return ((IObjectClassAwareModel)AjaxEditableLabel.this.getParentModel()).getObjectClass();
            }
            return null;
        }
    }

    protected class LabelAjaxBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        public LabelAjaxBehavior(String event) {
            super(event);
        }

        @Override
        protected void onEvent(AjaxRequestTarget target) {
            AjaxEditableLabel.this.onEdit(target);
        }

        @Override
        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxEditableLabel.this.updateLabelAjaxAttributes(attributes);
        }
    }

    protected class EditorAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected EditorAjaxBehavior() {
        }

        @Override
        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxEditableLabel.this.updateEditorAjaxAttributes(attributes);
        }

        @Override
        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            IPartialPageRequestHandler target = AjaxEditableLabel.this.getRequestCycle().find(IPartialPageRequestHandler.class);
            if (target != null) {
                CharSequence callbackScript = this.getCallbackScript(component);
                target.appendJavaScript(callbackScript);
            }
        }

        @Override
        protected void respond(AjaxRequestTarget target) {
            RequestCycle requestCycle = RequestCycle.get();
            boolean save = requestCycle.getRequest().getRequestParameters().getParameterValue("save").toBoolean(false);
            if (save) {
                AjaxEditableLabel.this.editor.processInput();
                if (AjaxEditableLabel.this.editor.isValid()) {
                    AjaxEditableLabel.this.onSubmit(target);
                } else {
                    AjaxEditableLabel.this.onError(target);
                }
            } else {
                AjaxEditableLabel.this.onCancel(target);
            }
        }
    }
}

