/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;

public final class CssUtils {
    public static final String INLINE_OPEN_TAG = "<style type=\"text/css\"><!--\n";
    public static final String INLINE_CLOSE_TAG = "--></style>\n";

    private CssUtils() {
    }

    public static void writeCss(Response response, CharSequence text, String id) {
        CssUtils.writeOpenTag(response, id);
        response.write(text);
        CssUtils.writeCloseTag(response);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write("<style type=\"text/css\" ");
        if (id != null) {
            response.write("id=\"" + id + "\"");
        }
        response.write("><!--\n");
    }

    public static void writeCloseTag(Response response) {
        response.write(INLINE_CLOSE_TAG);
    }

    public static void writeLinkUrl(Response response, CharSequence url, CharSequence media, String markupId) {
        response.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        response.write(Strings.escapeMarkup(url));
        response.write("\"");
        if (!Strings.isEmpty(media)) {
            response.write(" media=\"");
            response.write(Strings.escapeMarkup(media));
            response.write("\"");
        }
        if (!Strings.isEmpty(markupId)) {
            response.write(" id=\"");
            response.write(Strings.escapeMarkup(markupId));
            response.write("\"");
        }
        response.write(" />");
    }

    public static String key(Class<?> scope, String facet) {
        return Classes.simpleName(scope) + ".CSS." + facet;
    }
}

