/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class PackageResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private final IResourceStream resourceStream;

    public PackageResourceStream(Class<?> scope, String path) {
        this(scope, path, null, null, null);
    }

    public PackageResourceStream(Class<?> scope, String path, Locale locale, String style, String variation) {
        String absolutePath = Packages.absolutePath(scope, path);
        this.resourceStream = Application.get().getResourceSettings().getResourceStreamLocator().locate(scope, absolutePath, style, variation, locale, null, false);
        if (this.resourceStream == null) {
            throw new WicketRuntimeException("Cannot find resource with " + scope.getName() + " and path " + path);
        }
    }

    @Override
    public void close() throws IOException {
        this.resourceStream.close();
    }

    @Override
    public String getContentType() {
        return this.resourceStream.getContentType();
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.resourceStream.getInputStream();
    }

    @Override
    public Bytes length() {
        return this.resourceStream.length();
    }

    @Override
    public Time lastModifiedTime() {
        return this.resourceStream.lastModifiedTime();
    }
}

