/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.core.request.handler.RequestSettingRequestHandler;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.core.request.mapper.MapperUtils;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoMapper
implements IRequestMapperDelegate {
    private static final Logger log = LoggerFactory.getLogger(CryptoMapper.class);
    private static final String ENCRYPTED_PAGE_COMPONENT_INFO_PARAMETER = "wicket-crypt";
    private static final String ENCRYPTED_URL_MARKER_PREFIX = "crypt.";
    private final IRequestMapper wrappedMapper;
    private final IProvider<ICrypt> cryptProvider;
    private boolean markEncryptedUrls = false;

    public CryptoMapper(IRequestMapper wrappedMapper, Application application) {
        this(wrappedMapper, new ApplicationCryptProvider(application));
    }

    public CryptoMapper(IRequestMapper wrappedMapper, IProvider<ICrypt> cryptProvider) {
        this.wrappedMapper = Args.notNull(wrappedMapper, "wrappedMapper");
        this.cryptProvider = Args.notNull(cryptProvider, "cryptProvider");
    }

    public boolean getMarkEncryptedUrls() {
        return this.markEncryptedUrls;
    }

    public CryptoMapper setMarkEncryptedUrls(boolean markEncryptedUrls) {
        this.markEncryptedUrls = markEncryptedUrls;
        return this;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        Url decryptedUrl = this.decryptUrl(request, request.getUrl());
        if (decryptedUrl == null) {
            return 0;
        }
        Request decryptedRequest = request.cloneWithUrl(decryptedUrl);
        return this.wrappedMapper.getCompatibilityScore(decryptedRequest);
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.wrappedMapper.mapHandler(requestHandler);
        if (url == null) {
            return null;
        }
        if (url.isFull()) {
            return url;
        }
        return this.encryptUrl(url);
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        Url url = this.decryptUrl(request, request.getUrl());
        if (url == null) {
            return null;
        }
        Request decryptedRequest = request.cloneWithUrl(url);
        IRequestHandler handler = this.wrappedMapper.mapRequest(decryptedRequest);
        if (handler != null) {
            handler = new RequestSettingRequestHandler(decryptedRequest, handler);
        }
        return handler;
    }

    protected final ICrypt getCrypt() {
        return this.cryptProvider.get();
    }

    @Override
    public final IRequestMapper getDelegateMapper() {
        return this.wrappedMapper;
    }

    protected IMapperContext getContext() {
        return Application.get().getMapperContext();
    }

    protected Url encryptUrl(Url url) {
        if (url.getSegments().size() > 0 && url.getSegments().get(0).equals(this.getContext().getNamespace())) {
            return this.encryptEntireUrl(url);
        }
        return this.encryptRequestListenerParameter(url);
    }

    protected Url encryptEntireUrl(Url url) {
        String encryptedUrlString = this.getCrypt().encryptUrlSafe(url.toString());
        Url encryptedUrl = new Url(url.getCharset());
        if (this.getMarkEncryptedUrls()) {
            encryptedUrl.getSegments().add(ENCRYPTED_URL_MARKER_PREFIX + encryptedUrlString);
        } else {
            encryptedUrl.getSegments().add(encryptedUrlString);
        }
        int numberOfSegments = url.getSegments().size() - 1;
        HashedSegmentGenerator generator = new HashedSegmentGenerator(encryptedUrlString);
        for (int segNo = 0; segNo < numberOfSegments; ++segNo) {
            encryptedUrl.getSegments().add(generator.next());
        }
        return encryptedUrl;
    }

    protected Url encryptRequestListenerParameter(Url url) {
        Url encryptedUrl = new Url(url);
        boolean encrypted = false;
        Iterator<Url.QueryParameter> it = encryptedUrl.getQueryParameters().iterator();
        while (it.hasNext()) {
            Url.QueryParameter qp = it.next();
            if (MapperUtils.parsePageComponentInfoParameter(qp) == null) continue;
            it.remove();
            String encryptedParameterValue = this.getCrypt().encryptUrlSafe(qp.getName());
            Url.QueryParameter encryptedParameter = new Url.QueryParameter(ENCRYPTED_PAGE_COMPONENT_INFO_PARAMETER, encryptedParameterValue);
            encryptedUrl.getQueryParameters().add(0, encryptedParameter);
            encrypted = true;
            break;
        }
        if (encrypted) {
            return encryptedUrl;
        }
        return url;
    }

    protected Url decryptUrl(Request request, Url encryptedUrl) {
        Url url = this.decryptEntireUrl(request, encryptedUrl);
        if (url == null && encryptedUrl.getSegments().size() > 0 && encryptedUrl.getSegments().get(0).equals(this.getContext().getNamespace())) {
            if (request.getOriginalUrl().getSegments().size() > 0 && request.getOriginalUrl().getSegments().get(0).equals(this.getContext().getNamespace())) {
                return null;
            }
            return encryptedUrl;
        }
        if (url == null) {
            url = this.decryptRequestListenerParameter(request, encryptedUrl);
        }
        log.debug("Url '{}' has been decrypted to '{}'", (Object)encryptedUrl, (Object)url);
        return url;
    }

    protected Url decryptEntireUrl(Request request, Url encryptedUrl) {
        String encryptedSegment;
        String next;
        int segNo;
        String decryptedUrl;
        Url url = new Url(request.getCharset());
        List<String> encryptedSegments = encryptedUrl.getSegments();
        if (encryptedSegments.isEmpty()) {
            return null;
        }
        String encryptedUrlString = encryptedSegments.get(0);
        if (Strings.isEmpty(encryptedUrlString)) {
            return null;
        }
        if (this.getMarkEncryptedUrls()) {
            if (encryptedUrlString.startsWith(ENCRYPTED_URL_MARKER_PREFIX)) {
                encryptedUrlString = encryptedUrlString.substring(ENCRYPTED_URL_MARKER_PREFIX.length());
            } else {
                return null;
            }
        }
        try {
            decryptedUrl = this.getCrypt().decryptUrlSafe(encryptedUrlString);
        }
        catch (Exception e) {
            log.error("Error decrypting URL", e);
            return null;
        }
        if (decryptedUrl == null) {
            if (this.getMarkEncryptedUrls()) {
                throw new PageExpiredException("Encrypted URL is no longer decryptable");
            }
            return null;
        }
        Url originalUrl = Url.parse(decryptedUrl, request.getCharset());
        int originalNumberOfSegments = originalUrl.getSegments().size();
        int encryptedNumberOfSegments = encryptedUrl.getSegments().size();
        if (originalNumberOfSegments > 0) {
            url.getSegments().add(originalUrl.getSegments().get(0));
        }
        HashedSegmentGenerator generator = new HashedSegmentGenerator(encryptedUrlString);
        for (segNo = 1; segNo < encryptedNumberOfSegments && segNo < originalNumberOfSegments && (next = generator.next()).equals(encryptedSegment = encryptedSegments.get(segNo)); ++segNo) {
            url.getSegments().add(originalUrl.getSegments().get(segNo));
        }
        while (segNo < encryptedNumberOfSegments) {
            url.getSegments().add(encryptedUrl.getSegments().get(segNo));
            ++segNo;
        }
        url.getQueryParameters().addAll(originalUrl.getQueryParameters());
        url.getQueryParameters().addAll(encryptedUrl.getQueryParameters());
        return url;
    }

    protected Url decryptRequestListenerParameter(Request request, Url encryptedUrl) {
        Url url = new Url(encryptedUrl);
        url.getQueryParameters().clear();
        for (Url.QueryParameter qp : encryptedUrl.getQueryParameters()) {
            if (MapperUtils.parsePageComponentInfoParameter(qp) != null) {
                if (request.getOriginalUrl().getQueryParameter(qp.getName()) == null) {
                    url.getQueryParameters().add(qp);
                    continue;
                }
                return null;
            }
            if (ENCRYPTED_PAGE_COMPONENT_INFO_PARAMETER.equals(qp.getName())) {
                String encryptedValue = qp.getValue();
                if (Strings.isEmpty(encryptedValue)) {
                    url.getQueryParameters().add(qp);
                    continue;
                }
                String decryptedValue = null;
                try {
                    decryptedValue = this.getCrypt().decryptUrlSafe(encryptedValue);
                }
                catch (Exception e) {
                    log.error("Error decrypting encrypted request listener query parameter", e);
                }
                if (Strings.isEmpty(decryptedValue)) {
                    url.getQueryParameters().add(qp);
                    continue;
                }
                Url.QueryParameter decryptedParamter = new Url.QueryParameter(decryptedValue, "");
                url.getQueryParameters().add(0, decryptedParamter);
                continue;
            }
            url.getQueryParameters().add(qp);
        }
        return url;
    }

    public static class HashedSegmentGenerator {
        private char[] characters;
        private int hash = 0;

        public HashedSegmentGenerator(String string) {
            this.characters = string.toCharArray();
        }

        public String next() {
            char a = this.characters[Math.abs(this.hash % this.characters.length)];
            ++this.hash;
            char b = this.characters[Math.abs(this.hash % this.characters.length)];
            ++this.hash;
            char c = this.characters[Math.abs(this.hash % this.characters.length)];
            String segment = "" + a + b + c;
            this.hash = this.hashString(segment);
            segment = segment + String.format("%02x", Math.abs(this.hash % 256));
            this.hash = this.hashString(segment);
            return segment;
        }

        public int hashString(String str) {
            int hash = 97;
            char[] arr$ = str.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                char c;
                char i = c = arr$[i$];
                hash = 47 * hash + i;
            }
            return hash;
        }
    }

    private static class ApplicationCryptProvider
    implements IProvider<ICrypt> {
        private final Application application;

        public ApplicationCryptProvider(Application application) {
            this.application = application;
        }

        @Override
        public ICrypt get() {
            return this.application.getSecuritySettings().getCryptFactory().newCrypt();
        }
    }
}

