/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.string.Strings;

public class BookmarkableMapper
extends AbstractBookmarkableMapper {
    public BookmarkableMapper() {
        this(new PageParametersEncoder());
    }

    public BookmarkableMapper(IPageParametersEncoder pageParametersEncoder) {
        super("notUsed", pageParametersEncoder);
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        url.getSegments().add(this.getContext().getNamespace());
        url.getSegments().add(this.getContext().getBookmarkableIdentifier());
        url.getSegments().add(info.getPageClass().getName());
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        if (this.matches(request)) {
            Url url = request.getUrl();
            PageComponentInfo info = this.getPageComponentInfo(url);
            List<String> segments = url.getSegments();
            String className = segments.size() >= 3 ? segments.get(2) : segments.get(1);
            if (Strings.isEmpty(className)) {
                return null;
            }
            Class<? extends IRequestablePage> pageClass = this.getPageClass(className);
            if (pageClass != null && IRequestablePage.class.isAssignableFrom(pageClass)) {
                Application application;
                if (Application.exists() && (application = Application.get()).getSecuritySettings().getEnforceMounts() && !pageClass.equals(application.getHomePage()) && this.isPageMounted(pageClass, application.getRootRequestMapperAsCompound())) {
                    return null;
                }
                PageParameters pageParameters = this.extractPageParameters(request, 3, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    private boolean isPageMounted(Class<? extends IRequestablePage> pageClass, ICompoundRequestMapper compoundMapper) {
        for (IRequestMapper requestMapper : compoundMapper) {
            AbstractBookmarkableMapper mapper;
            while (requestMapper instanceof IRequestMapperDelegate) {
                requestMapper = ((IRequestMapperDelegate)requestMapper).getDelegateMapper();
            }
            if (!(requestMapper instanceof ICompoundRequestMapper ? this.isPageMounted(pageClass, (ICompoundRequestMapper)requestMapper) : requestMapper instanceof AbstractBookmarkableMapper && requestMapper != this && (mapper = (AbstractBookmarkableMapper)requestMapper).checkPageClass(pageClass))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = 0;
        if (this.matches(request)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Request request) {
        boolean matches = false;
        Url url = request.getUrl();
        Url baseUrl = request.getClientUrl();
        String namespace = this.getContext().getNamespace();
        String bookmarkableIdentifier = this.getContext().getBookmarkableIdentifier();
        String pageIdentifier = this.getContext().getPageIdentifier();
        List<String> segments = url.getSegments();
        int segmentsSize = segments.size();
        if (segmentsSize >= 3 && this.urlStartsWithAndHasPageClass(url, namespace, bookmarkableIdentifier)) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 3 && this.urlStartsWith(baseUrl, namespace, bookmarkableIdentifier) && segmentsSize >= 2 && this.urlStartsWithAndHasPageClass(url, bookmarkableIdentifier)) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, bookmarkableIdentifier) && segmentsSize == 2 && this.urlStartsWithAndHasPageClass(url, bookmarkableIdentifier)) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, namespace, pageIdentifier) && segmentsSize >= 2 && this.urlStartsWithAndHasPageClass(url, bookmarkableIdentifier)) {
            matches = true;
        }
        return matches;
    }

    protected boolean urlStartsWithAndHasPageClass(Url url, String ... segments) {
        boolean result = this.urlStartsWith(url, segments);
        if (result) {
            List<String> urlSegments = url.getSegments();
            if (urlSegments.size() == segments.length) {
                result = false;
            } else {
                String pageClassSegment = urlSegments.get(segments.length);
                if (Strings.isEmpty(pageClassSegment)) {
                    result = false;
                }
            }
        }
        return result;
    }
}

