/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.logger.PageLogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderPageRequestHandler
implements IPageRequestHandler,
IPageClassRequestHandler,
ILoggableRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(RenderPageRequestHandler.class);
    private final IPageProvider pageProvider;
    private final RedirectPolicy redirectPolicy;
    private PageLogData logData;

    public RenderPageRequestHandler(IPageProvider pageProvider) {
        this(pageProvider, RedirectPolicy.AUTO_REDIRECT);
    }

    public RenderPageRequestHandler(IPageProvider pageProvider, RedirectPolicy redirectPolicy) {
        Args.notNull(pageProvider, "pageProvider");
        Args.notNull(redirectPolicy, "redirectPolicy");
        this.redirectPolicy = redirectPolicy;
        this.pageProvider = pageProvider;
        if (pageProvider.hasPageInstance() && Session.exists()) {
            Session.get().getPageManager().touchPage(pageProvider.getPageInstance());
        }
    }

    public IPageProvider getPageProvider() {
        return this.pageProvider;
    }

    public RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageProvider.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.pageProvider.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageProvider.getPageParameters();
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new PageLogData(this.pageProvider);
        }
        this.pageProvider.detach();
    }

    @Override
    public PageLogData getLogData() {
        return this.logData;
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageProvider.getPageInstance();
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
        PageRenderer renderer = (PageRenderer)Application.get().getPageRendererProvider().get(this);
        renderer.respond((RequestCycle)requestCycle);
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return this.pageProvider.hasPageInstance();
    }

    @Override
    public final Integer getRenderCount() {
        return this.pageProvider.getRenderCount();
    }

    public static enum RedirectPolicy {
        ALWAYS_REDIRECT,
        NEVER_REDIRECT,
        AUTO_REDIRECT;

    }
}

