/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Page;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.ComponentNotFoundException;
import org.apache.wicket.core.request.handler.IComponentRequestHandler;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.handler.logger.ListenerInterfaceLogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerInterfaceRequestHandler
implements IPageRequestHandler,
IComponentRequestHandler,
ILoggableRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerInterfaceRequestHandler.class);
    private final IPageAndComponentProvider pageComponentProvider;
    private final RequestListenerInterface listenerInterface;
    private final Integer behaviorId;
    private ListenerInterfaceLogData logData;

    public ListenerInterfaceRequestHandler(IPageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface, Integer behaviorIndex) {
        Args.notNull(pageComponentProvider, "pageComponentProvider");
        Args.notNull(listenerInterface, "listenerInterface");
        this.pageComponentProvider = pageComponentProvider;
        this.listenerInterface = listenerInterface;
        this.behaviorId = behaviorIndex;
    }

    public ListenerInterfaceRequestHandler(PageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface) {
        this(pageComponentProvider, listenerInterface, null);
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.pageComponentProvider.getComponent();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageComponentProvider.getPageInstance();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageComponentProvider.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.pageComponentProvider.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageComponentProvider.getPageParameters();
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new ListenerInterfaceLogData(this.pageComponentProvider, this.listenerInterface, this.behaviorId);
        }
        this.pageComponentProvider.detach();
    }

    public RequestListenerInterface getListenerInterface() {
        return this.listenerInterface;
    }

    public Integer getBehaviorIndex() {
        return this.behaviorId;
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
        boolean canCallListenerInterfaceAfterExpiry;
        boolean isStateless;
        IRequestableComponent component;
        IRequestablePage page = this.getPage();
        boolean freshPage = this.pageComponentProvider.isPageInstanceFresh();
        boolean isAjax = ((WebRequest)requestCycle.getRequest()).isAjax();
        try {
            component = this.getComponent();
        }
        catch (ComponentNotFoundException e) {
            component = null;
        }
        if (component == null && !freshPage || component != null && component.getPage() != page) {
            throw new ComponentNotFoundException("Component '" + this.getComponentPath() + "' has been removed from page.");
        }
        if (page instanceof Page) {
            ((Page)page).internalInitialize();
        }
        RenderPageRequestHandler.RedirectPolicy policy = (isStateless = page.isPageStateless()) ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT;
        PageProvider pageProvider = new PageProvider(page);
        boolean bl = canCallListenerInterfaceAfterExpiry = component != null ? component.canCallListenerInterfaceAfterExpiry() : false;
        if (!canCallListenerInterfaceAfterExpiry && freshPage && (this.pageComponentProvider.getPageId() != null || component == null)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("A ListenerInterface '{}' assigned to '{}' is executed on an expired stateful page. Scheduling re-create of the page and ignoring the listener interface...", (Object)this.listenerInterface, (Object)this.getComponentPath());
            }
            if (isAjax) {
                policy = RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
            }
            requestCycle.scheduleRequestHandlerAfterCurrent(new RenderPageRequestHandler(pageProvider, policy));
            return;
        }
        if (!isAjax && this.listenerInterface.isRenderPageAfterInvocation()) {
            requestCycle.scheduleRequestHandlerAfterCurrent(new RenderPageRequestHandler(pageProvider, policy));
        }
        this.invokeListener();
    }

    private void invokeListener() {
        if (this.getBehaviorIndex() == null) {
            this.listenerInterface.invoke(this.getComponent());
        } else {
            try {
                Behavior behavior = this.getComponent().getBehaviorById(this.behaviorId);
                this.listenerInterface.invoke(this.getComponent(), behavior);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WicketRuntimeException("Couldn't find component behavior.", e);
            }
        }
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return this.pageComponentProvider.hasPageInstance();
    }

    @Override
    public final String getComponentPath() {
        return this.pageComponentProvider.getComponentPath();
    }

    @Override
    public final Integer getRenderCount() {
        return this.pageComponentProvider.getRenderCount();
    }

    @Override
    public ListenerInterfaceLogData getLogData() {
        return this.logData;
    }
}

