/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class AjaxChannel
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME = "0";
    public static final Type DEFAULT_TYPE = Type.QUEUE;
    public static final AjaxChannel DEFAULT = new AjaxChannel("0", DEFAULT_TYPE);
    private final String name;
    private final Type type;

    public AjaxChannel(String name) {
        this(name, Type.QUEUE);
    }

    public AjaxChannel(String name, Type type) {
        this.name = Args.notNull(name, "name");
        this.type = Args.notNull(type, "type");
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    String getChannelName() {
        return this.toString();
    }

    public String toString() {
        return String.format("%s|%s", this.name, this.getShortType(this.type));
    }

    private String getShortType(Type t) {
        String shortType;
        switch (t) {
            case DROP: {
                shortType = "d";
                break;
            }
            case ACTIVE: {
                shortType = "a";
                break;
            }
            default: {
                shortType = "s";
            }
        }
        return shortType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AjaxChannel that = (AjaxChannel)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static enum Type {
        QUEUE,
        DROP,
        ACTIVE;

    }
}

