/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Application;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.UrlResourceReferenceMapper;
import org.apache.wicket.core.request.mapper.BookmarkableMapper;
import org.apache.wicket.core.request.mapper.BufferedResponseMapper;
import org.apache.wicket.core.request.mapper.HomePageMapper;
import org.apache.wicket.core.request.mapper.PageInstanceMapper;
import org.apache.wicket.core.request.mapper.ResourceReferenceMapper;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.CompoundRequestMapper;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.util.IProvider;

public class SystemMapper
extends CompoundRequestMapper {
    private final Application application;

    public SystemMapper(Application application) {
        this.application = application;
        this.add(this.newPageInstanceMapper());
        this.add(this.newBookmarkableMapper());
        this.add(this.newHomePageMapper(new HomePageProvider(application)));
        this.add(this.newResourceReferenceMapper(new PageParametersEncoder(), new ParentFolderPlaceholderProvider(application), this.getResourceCachingStrategy()));
        this.add(this.newUrlResourceReferenceMapper());
        this.add(RestartResponseAtInterceptPageException.MAPPER);
        this.add(this.newBufferedResponseMapper());
    }

    protected IRequestMapper newBufferedResponseMapper() {
        return new BufferedResponseMapper();
    }

    protected IRequestMapper newUrlResourceReferenceMapper() {
        return new UrlResourceReferenceMapper();
    }

    private IRequestMapper newResourceReferenceMapper(PageParametersEncoder pageParametersEncoder, ParentFolderPlaceholderProvider parentFolderPlaceholderProvider, IProvider<IResourceCachingStrategy> resourceCachingStrategy) {
        return new ResourceReferenceMapper(pageParametersEncoder, parentFolderPlaceholderProvider, resourceCachingStrategy);
    }

    protected IRequestMapper newBookmarkableMapper() {
        return new BookmarkableMapper();
    }

    protected IRequestMapper newPageInstanceMapper() {
        return new PageInstanceMapper();
    }

    protected IRequestMapper newHomePageMapper(IProvider<Class<? extends IRequestablePage>> homePageProvider) {
        return new HomePageMapper(homePageProvider);
    }

    protected IProvider<IResourceCachingStrategy> getResourceCachingStrategy() {
        return new IProvider<IResourceCachingStrategy>(){

            @Override
            public IResourceCachingStrategy get() {
                return SystemMapper.this.application.getResourceSettings().getCachingStrategy();
            }
        };
    }

    protected static class HomePageProvider<C extends IRequestablePage>
    implements IProvider<Class<C>> {
        private final Application application;

        protected HomePageProvider(Application application) {
            this.application = application;
        }

        @Override
        public Class<C> get() {
            return this.application.getHomePage();
        }
    }

    protected static class ParentFolderPlaceholderProvider
    implements IProvider<String> {
        private final Application application;

        protected ParentFolderPlaceholderProvider(Application application) {
            this.application = application;
        }

        @Override
        public String get() {
            return this.application.getResourceSettings().getParentFolderPlaceholder();
        }
    }
}

