/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;
import org.apache.wicket.resource.bundles.ConcatResourceBundleReference;
import org.apache.wicket.util.lang.Args;

public class ResourceBundles {
    private final ResourceReferenceRegistry registry;
    private final Map<HeaderItem, HeaderItem> providedResourcesToBundles;

    public ResourceBundles(ResourceReferenceRegistry registry) {
        this.registry = Args.notNull(registry, "registry");
        this.providedResourcesToBundles = new HashMap<HeaderItem, HeaderItem>();
    }

    public JavaScriptReferenceHeaderItem addJavaScriptBundle(Class<?> scope, String name, JavaScriptResourceReference ... references) {
        return this.addJavaScriptBundle(scope, name, false, references);
    }

    public JavaScriptReferenceHeaderItem addJavaScriptBundle(Class<?> scope, String name, boolean defer, JavaScriptResourceReference ... references) {
        ArrayList<JavaScriptReferenceHeaderItem> items = new ArrayList<JavaScriptReferenceHeaderItem>();
        for (JavaScriptResourceReference curReference : references) {
            items.add(JavaScriptHeaderItem.forReference(curReference));
        }
        ConcatResourceBundleReference bundleReference = this.newBundleResourceReference(scope, name, items);
        if (Application.exists()) {
            IJavaScriptCompressor javaScriptCompressor = Application.get().getResourceSettings().getJavaScriptCompressor();
            bundleReference.setCompressor(javaScriptCompressor);
        }
        if (defer) {
            return this.addBundle(JavaScriptHeaderItem.forReference(bundleReference, defer));
        }
        return this.addBundle(JavaScriptHeaderItem.forReference(bundleReference));
    }

    public CssReferenceHeaderItem addCssBundle(Class<?> scope, String name, CssResourceReference ... references) {
        ArrayList<CssReferenceHeaderItem> items = new ArrayList<CssReferenceHeaderItem>();
        for (CssResourceReference curReference : references) {
            items.add(CssHeaderItem.forReference(curReference));
        }
        ConcatResourceBundleReference bundleReference = this.newBundleResourceReference(scope, name, items);
        if (Application.exists()) {
            ICssCompressor cssCompressor = Application.get().getResourceSettings().getCssCompressor();
            bundleReference.setCompressor(cssCompressor);
        }
        return this.addBundle(CssHeaderItem.forReference(bundleReference));
    }

    protected <T extends HeaderItem> ConcatResourceBundleReference<T> newBundleResourceReference(Class<?> scope, String name, List<T> items) {
        return new ConcatResourceBundleReference<T>(scope, name, items);
    }

    public <T extends HeaderItem> T addBundle(T bundle) {
        ResourceReference reference;
        for (HeaderItem headerItem : bundle.getProvidedResources()) {
            if (this.providedResourcesToBundles.containsKey(headerItem)) {
                throw new IllegalArgumentException("Only one bundle can provide a certain resource. " + this.providedResourcesToBundles.get(headerItem) + " already provides the resource " + headerItem);
            }
            this.providedResourcesToBundles.put(headerItem, bundle);
        }
        if (bundle instanceof IReferenceHeaderItem && (reference = ((IReferenceHeaderItem)((Object)bundle)).getReference()).canBeRegistered()) {
            this.registry.registerResourceReference(reference);
        }
        return bundle;
    }

    public HeaderItem findBundle(HeaderItem item) {
        return this.providedResourcesToBundles.get(item);
    }
}

